package com.xforceplus.elephant.image.openapi.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 退回单证
 */
@ApiModel(description = "退回单证")

@JsonInclude(NON_NULL)
public class BackTicketRequest {
  @JsonProperty("tenantId")
  private String tenantId = null;

  @JsonProperty("imageId")
  private String imageId = null;

  @JsonProperty("userName")
  private String userName = null;

  @JsonProperty("returnRemark")
  private String returnRemark = null;

  @JsonIgnore
  public BackTicketRequest tenantId(String tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户ID
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户ID")
  public String getTenantId() {
    return tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public BackTicketRequest imageId(String imageId) {
    this.imageId = imageId;
    return this;
  }

   /**
   * 影像id
   * @return imageId
  **/
  @ApiModelProperty(value = "影像id")
  public String getImageId() {
    return imageId;
  }

  public void setImageId(String imageId) {
    this.imageId = imageId;
  }

  @JsonIgnore
  public BackTicketRequest userName(String userName) {
    this.userName = userName;
    return this;
  }

   /**
   * 用户名
   * @return userName
  **/
  @ApiModelProperty(value = "用户名")
  public String getUserName() {
    return userName;
  }

  public void setUserName(String userName) {
    this.userName = userName;
  }

  @JsonIgnore
  public BackTicketRequest returnRemark(String returnRemark) {
    this.returnRemark = returnRemark;
    return this;
  }

   /**
   * 退回备注
   * @return returnRemark
  **/
  @ApiModelProperty(value = "退回备注")
  public String getReturnRemark() {
    return returnRemark;
  }

  public void setReturnRemark(String returnRemark) {
    this.returnRemark = returnRemark;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BackTicketRequest backTicketRequest = (BackTicketRequest) o;
    return Objects.equals(this.tenantId, backTicketRequest.tenantId) &&
        Objects.equals(this.imageId, backTicketRequest.imageId) &&
        Objects.equals(this.userName, backTicketRequest.userName) &&
        Objects.equals(this.returnRemark, backTicketRequest.returnRemark);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tenantId, imageId, userName, returnRemark);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BackTicketRequest {\n");
    
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    imageId: ").append(toIndentedString(imageId)).append("\n");
    sb.append("    userName: ").append(toIndentedString(userName)).append("\n");
    sb.append("    returnRemark: ").append(toIndentedString(returnRemark)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
