package com.xforceplus.elephant.image.openapi.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Objects;

/**
 * 单据数据对象
 */
@ApiModel(description = "单据数据对象")

@JsonInclude(NON_NULL)
public class BillMain {

    @JsonProperty("tenantId")
    private String tenantId = null;

    @JsonProperty("tenantCode")
    private String tenantCode = null;

    @JsonProperty("billCodeType")
    private String billCodeType = null;

    @JsonProperty("billCode")
    private String billCode = null;

    @JsonProperty("userId")
    private String userId = null;

    @JsonProperty("userName")
    private String userName = null;

    @JsonProperty("createTime")
    private String createTime = null;

    @JsonProperty("totalAmount")
    private String totalAmount = "0";

    @JsonProperty("taxAmount")
    private String taxAmount = "0";

    @JsonProperty("amountWithoutTax")
    private String amountWithoutTax = "0";

    @JsonProperty("systemOrig")
    private String systemOrig = null;

    @JsonProperty("remark")
    private String remark = null;

    @JsonProperty("extFields")
    private Map<String, Object> extFields = null;

    @JsonProperty("orgCode")
    private String orgCode = null;

    //重庆医药专用
    @JsonProperty("billCodeSubType")
    private String billCodeSubType = null;


    @JsonProperty("isBusinessExpenses")
    private String isBusinessExpenses = null;

    //重庆医药专用
    @JsonProperty("isNeedScan")
    private String isNeedScan = "1";

    @JsonProperty("purchaserName")
    private String purchaserName;


    @JsonProperty("purchaserTaxNo")
    private String purchaserTaxNo;

    @JsonProperty("status")
    private String status;

    @JsonProperty("businessType")
    private String businessType;

    @JsonProperty("settlementNo")
    private String settlementNo;

    @JsonProperty("billUse")
    private String billUse;

    private Integer payStatus;

    private String auditRemark;

    @JsonProperty("settlementType")
    private String settlementType;

    /**
     * 0否（默认值)会先脱挂再挂接 1是 直接追加挂接(单次请求限制100条)
     */
    @JsonProperty("isAddHook")
    private String isAddHook = "0";

    /**
     * 1-挂接（默认），2-脱挂
     */
    @JsonProperty("hookType")
    private String hookType = "1";

    @JsonProperty("usedAmount")
    private BigDecimal usedAmount;

    /**
     * 提单人邮箱
     */
    @JsonProperty("billCreateEmail")
    private String billCreateEmail;

    public String getBillCreateEmail() {
        return billCreateEmail;
    }

    public void setBillCreateEmail(String billCreateEmail) {
        this.billCreateEmail = billCreateEmail;
    }

    public String getBillUse() {
        return billUse;
    }

    public void setBillUse(String billUse) {
        this.billUse = billUse;
    }

    public String getSettlementNo() {
        return settlementNo;
    }

    public void setSettlementNo(String settlementNo) {
        this.settlementNo = settlementNo;
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getPurchaserName() {
        return purchaserName;
    }

    public void setPurchaserName(String purchaserName) {
        this.purchaserName = purchaserName;
    }

    public String getPurchaserTaxNo() {
        return purchaserTaxNo;
    }

    public void setPurchaserTaxNo(String purchaserTaxNo) {
        this.purchaserTaxNo = purchaserTaxNo;
    }


    public String getIsNeedScan() {
        return isNeedScan;
    }

    public void setIsNeedScan(String isNeedScan) {
        this.isNeedScan = isNeedScan;
    }

    public String getBillCodeSubType() {
        return billCodeSubType;
    }

    public void setBillCodeSubType(String billCodeSubType) {
        this.billCodeSubType = billCodeSubType;
    }

    public String getIsBusinessExpenses() {
        return isBusinessExpenses;
    }

    public void setIsBusinessExpenses(String isBusinessExpenses) {
        this.isBusinessExpenses = isBusinessExpenses;
    }

    @JsonIgnore
    public BillMain tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    /**
     * 租户ID
     *
     * @return tenantId
     **/
    @ApiModelProperty(value = "租户ID")
    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @JsonIgnore
    public BillMain billCodeType(String billCodeType) {
        this.billCodeType = billCodeType;
        return this;
    }

    /**
     * 单据类型：1-对公，2-私，3-对公预付款，4-对私预付款
     *
     * @return billCodeType
     **/
    @ApiModelProperty(value = "单据类型：1-对公，2-私，3-对公预付款，4-对私预付款")
    public String getBillCodeType() {
        return billCodeType;
    }

    public void setBillCodeType(String billCodeType) {
        this.billCodeType = billCodeType;
    }

    @JsonIgnore
    public BillMain billCode(String billCode) {
        this.billCode = billCode;
        return this;
    }

    /**
     * 单据号
     *
     * @return billCode
     **/
    @ApiModelProperty(value = "单据号")
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @JsonIgnore
    public BillMain userId(String userId) {
        this.userId = userId;
        return this;
    }

    /**
     * 用户id
     *
     * @return userId
     **/
    @ApiModelProperty(value = "用户id")
    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    @JsonIgnore
    public BillMain userName(String userName) {
        this.userName = userName;
        return this;
    }

    /**
     * 用户名
     *
     * @return userName
     **/
    @ApiModelProperty(value = "用户名")
    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @JsonIgnore
    public BillMain createTime(String createTime) {
        this.createTime = createTime;
        return this;
    }

    /**
     * 提单时间
     *
     * @return createTime
     **/
    @ApiModelProperty(value = "提单时间")
    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    @JsonIgnore
    public BillMain totalAmount(String totalAmount) {
        this.totalAmount = totalAmount;
        return this;
    }

    /**
     * 含税金额
     *
     * @return totalAmount
     **/
    @ApiModelProperty(value = "含税金额")
    public String getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(String totalAmount) {
        this.totalAmount = totalAmount;
    }


    @JsonIgnore
    public BillMain systemOrig(String systemOrig) {
        this.systemOrig = systemOrig;
        return this;
    }

    /**
     * 系统来源
     *
     * @return systemOrig
     **/
    @ApiModelProperty(value = "系统来源")
    public String getSystemOrig() {
        return systemOrig;
    }

    public void setSystemOrig(String systemOrig) {
        this.systemOrig = systemOrig;
    }

    @JsonIgnore
    public BillMain remark(String remark) {
        this.remark = remark;
        return this;
    }

    /**
     * 备注
     *
     * @return remark
     **/
    @ApiModelProperty(value = "备注")
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    @JsonIgnore
    public BillMain extFields(Map<String, Object> extFields) {
        this.extFields = extFields;
        return this;
    }

    /**
     * 扩展字段
     *
     * @return extFields
     **/
    @ApiModelProperty(value = "扩展字段")
    public Map<String, Object> getExtFields() {
        return extFields;
    }

    public void setExtFields(Map<String, Object> extFields) {
        this.extFields = extFields;
    }


    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BillMain billMain = (BillMain) o;
        return Objects.equals(this.tenantId, billMain.tenantId) &&
            Objects.equals(this.billCodeType, billMain.billCodeType) &&
            Objects.equals(this.billCode, billMain.billCode) &&
            Objects.equals(this.userId, billMain.userId) &&
            Objects.equals(this.userName, billMain.userName) &&
            Objects.equals(this.createTime, billMain.createTime) &&
            Objects.equals(this.totalAmount, billMain.totalAmount) &&
            Objects.equals(this.systemOrig, billMain.systemOrig) &&
            Objects.equals(this.remark, billMain.remark) &&
            Objects.equals(this.extFields, billMain.extFields);
    }

    @Override
    public int hashCode() {
        return Objects.hash(tenantId, billCodeType, billCode, userId, userName, createTime, totalAmount, systemOrig, remark, extFields);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BillMain {\n");

        sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
        sb.append("    billCodeType: ").append(toIndentedString(billCodeType)).append("\n");
        sb.append("    billCode: ").append(toIndentedString(billCode)).append("\n");
        sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
        sb.append("    userName: ").append(toIndentedString(userName)).append("\n");
        sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
        sb.append("    totalAmount: ").append(toIndentedString(totalAmount)).append("\n");
        sb.append("    systemOrig: ").append(toIndentedString(systemOrig)).append("\n");
        sb.append("    remark: ").append(toIndentedString(remark)).append("\n");
        sb.append("    extFields: ").append(toIndentedString(extFields)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public Integer getPayStatus() {
        return payStatus;
    }

    public void setPayStatus(Integer payStatus) {
        this.payStatus = payStatus;
    }

    public String getAuditRemark() {
        return auditRemark;
    }

    public void setAuditRemark(String auditRemark) {
        this.auditRemark = auditRemark;
    }

    public String getSettlementType() {
        return settlementType;
    }

    public void setSettlementType(String settlementType) {
        this.settlementType = settlementType;
    }

    public String getIsAddHook() {
        return isAddHook;
    }

    public void setIsAddHook(String isAddHook) {
        this.isAddHook = isAddHook;
    }

    public String getTenantCode() {
        return tenantCode;
    }

    public void setTenantCode(String tenantCode) {
        this.tenantCode = tenantCode;
    }

    public String getAmountWithoutTax() {
        return amountWithoutTax;
    }

    public void setAmountWithoutTax(String amountWithoutTax) {
        this.amountWithoutTax = amountWithoutTax;
    }

    public String getTaxAmount() {
        return taxAmount;
    }

    public void setTaxAmount(String taxAmount) {
        this.taxAmount = taxAmount;
    }

    public String getHookType() {
        return hookType;
    }

    public void setHookType(String hookType) {
        this.hookType = hookType;
    }

    public BigDecimal getUsedAmount() {
        return usedAmount;
    }

    public void setUsedAmount(BigDecimal usedAmount) {
        this.usedAmount = usedAmount;
    }

}
