package com.xforceplus.elephant.image.openapi.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import lombok.Data;

/**
 * image-openapi
 *
 * @author liuhongbin
 * @date 2023/6/19 15:41
 */
@Data
public class DataCheckRequestDTO {

    @JsonProperty("source")
    private String source;

    @NotNull(message = "【dataType】不能为空")
    @Pattern(regexp = "^(1|2)$", message = "【dataType】的值必须在 1/2 之间")
    @JsonProperty("dataType")
    private String dataType;

    @NotNull(message = "【queryTime】不能为空")
    @Pattern(regexp = "^[0-9]{1,15}$", message = "【queryTime】的值必须是时间戳（毫秒）")
    @JsonProperty("queryTime")
    private String queryTime;

    @Min(value = 1, message = "【pageSize】不能小于1")
    @Max(value = 1000, message = "【pageSize】不能大于1000")
    @JsonProperty("pageSize")
    private String pageSize = "1000";

    @JsonProperty("lastId")
    private String lastId;

}
