package com.xforceplus.elephant.image.openapi.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Objects;

/**
 * 获取影像详情Request
 */
@ApiModel(description = "获取影像详情Request")

@JsonInclude(NON_NULL)
public class GetImageUrlRequest {

    @JsonProperty("tenantId")
    private String tenantId = null;

    @JsonProperty("tenantCode")
    private String tenantCode = null;

    @JsonProperty("requestNo")
    private String requestNo = null;

    @JsonProperty("userCode")
    private String userCode = null;

    @JsonProperty("systemOrig")
    private String systemOrig = null;

    @JsonProperty("userName")
    private String userName = null;

    @JsonProperty("imageIds")
    private List<Long> imageIds;

    public List<Long> getImageIds() {
        return imageIds;
    }

    public void setImageIds(List<Long> imageIds) {
        this.imageIds = imageIds;
    }

    @JsonIgnore
    public GetImageUrlRequest tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    /**
     * 租户ID
     *
     * @return tenantId
     **/
    @ApiModelProperty(value = "租户ID")
    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @JsonIgnore
    public GetImageUrlRequest tenantCode(String tenantCode) {
        this.tenantCode = tenantCode;
        return this;
    }

    /**
     * 租户Code
     *
     * @return tenantCode
     **/
    @ApiModelProperty(value = "租户Code")
    public String getTenantCode() {
        return tenantCode;
    }

    public void setTenantCode(String tenantCode) {
        this.tenantCode = tenantCode;
    }

    @JsonIgnore
    public GetImageUrlRequest requestNo(String requestNo) {
        this.requestNo = requestNo;
        return this;
    }

    /**
     * 请求编号
     *
     * @return requestNo
     **/
    @ApiModelProperty(value = "请求编号")
    public String getRequestNo() {
        return requestNo;
    }

    public void setRequestNo(String requestNo) {
        this.requestNo = requestNo;
    }

    @JsonIgnore
    public GetImageUrlRequest userCode(String userCode) {
        this.userCode = userCode;
        return this;
    }

    /**
     * 用户账号
     *
     * @return userCode
     **/
    @ApiModelProperty(value = "用户账号")
    public String getUserCode() {
        return userCode;
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    @JsonIgnore
    public GetImageUrlRequest systemOrig(String systemOrig) {
        this.systemOrig = systemOrig;
        return this;
    }

    /**
     * 来源系统
     *
     * @return systemOrig
     **/
    @ApiModelProperty(value = "来源系统")
    public String getSystemOrig() {
        return systemOrig;
    }

    public void setSystemOrig(String systemOrig) {
        this.systemOrig = systemOrig;
    }

    @JsonIgnore
    public GetImageUrlRequest userName(String userName) {
        this.userName = userName;
        return this;
    }

    /**
     * 用户姓名
     *
     * @return userName
     **/
    @ApiModelProperty(value = "用户姓名")
    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetImageUrlRequest getImageUrlRequest = (GetImageUrlRequest) o;
        return Objects.equals(this.tenantId, getImageUrlRequest.tenantId) &&
            Objects.equals(this.tenantCode, getImageUrlRequest.tenantCode) &&
            Objects.equals(this.requestNo, getImageUrlRequest.requestNo) &&
            Objects.equals(this.userCode, getImageUrlRequest.userCode) &&
            Objects.equals(this.systemOrig, getImageUrlRequest.systemOrig) &&
            Objects.equals(this.userName, getImageUrlRequest.userName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(tenantId, tenantCode, requestNo, userCode, systemOrig, userName);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetImageUrlRequest {\n");

        sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
        sb.append("    tenantCode: ").append(toIndentedString(tenantCode)).append("\n");
        sb.append("    requestNo: ").append(toIndentedString(requestNo)).append("\n");
        sb.append("    userCode: ").append(toIndentedString(userCode)).append("\n");
        sb.append("    systemOrig: ").append(toIndentedString(systemOrig)).append("\n");
        sb.append("    userName: ").append(toIndentedString(userName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
