package com.xforceplus.elephant.image.openapi.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

public class HookBillDTO {

    @Valid
    @NotNull(message = "【billMain】不能为空")
    private SaveBillDataDTO billMain = null;

    @Valid
    @JsonProperty("invoiceList")
    private List<InvoiceList> invoiceList = new ArrayList<>();

    @JsonProperty("autoRelationSync")
    private boolean autoRelationSync = false;

    public SaveBillDataDTO getBillMain() {
        return billMain;
    }

    public void setBillMain(final SaveBillDataDTO billMain) {
        this.billMain = billMain;
    }

    public List<InvoiceList> getInvoiceList() {
        return invoiceList;
    }

    public void setInvoiceList(final List<InvoiceList> invoiceList) {
        this.invoiceList = invoiceList;
    }

    public boolean isAutoRelationSync() {
        return autoRelationSync;
    }

    public void setAutoRelationSync(final boolean autoRelationSync) {
        this.autoRelationSync = autoRelationSync;
    }

}
