package com.xforceplus.elephant.image.openapi.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.elephant.image.openapi.client.model.ImageStructObj;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 影像数据对象
 */
@ApiModel(description = "影像数据对象")

@JsonInclude(NON_NULL)
public class ImageDataObj {
  @JsonProperty("tenantId")
  private String tenantId = null;

  @JsonProperty("imageId")
  private String imageId = null;

  @JsonProperty("imageType")
  private String imageType = null;

  @JsonProperty("imageUrl")
  private String imageUrl = null;

  @JsonProperty("sacnUserName")
  private String sacnUserName = null;

  @JsonProperty("scanTime")
  private String scanTime = null;

  @JsonProperty("imageInfo")
  private List<ImageStructObj> imageInfo = new ArrayList<ImageStructObj>();

  @JsonIgnore
  public ImageDataObj tenantId(String tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户ID
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户ID")
  public String getTenantId() {
    return tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public ImageDataObj imageId(String imageId) {
    this.imageId = imageId;
    return this;
  }

   /**
   * 影像ID
   * @return imageId
  **/
  @ApiModelProperty(value = "影像ID")
  public String getImageId() {
    return imageId;
  }

  public void setImageId(String imageId) {
    this.imageId = imageId;
  }

  @JsonIgnore
  public ImageDataObj imageType(String imageType) {
    this.imageType = imageType;
    return this;
  }

   /**
   * 影像类型:1-单据，2-单证，3-多票，4-附件
   * @return imageType
  **/
  @ApiModelProperty(value = "影像类型:1-单据，2-单证，3-多票，4-附件")
  public String getImageType() {
    return imageType;
  }

  public void setImageType(String imageType) {
    this.imageType = imageType;
  }

  @JsonIgnore
  public ImageDataObj imageUrl(String imageUrl) {
    this.imageUrl = imageUrl;
    return this;
  }

   /**
   * 影像地址
   * @return imageUrl
  **/
  @ApiModelProperty(value = "影像地址")
  public String getImageUrl() {
    return imageUrl;
  }

  public void setImageUrl(String imageUrl) {
    this.imageUrl = imageUrl;
  }

  @JsonIgnore
  public ImageDataObj sacnUserName(String sacnUserName) {
    this.sacnUserName = sacnUserName;
    return this;
  }

   /**
   * 扫描人
   * @return sacnUserName
  **/
  @ApiModelProperty(value = "扫描人")
  public String getSacnUserName() {
    return sacnUserName;
  }

  public void setSacnUserName(String sacnUserName) {
    this.sacnUserName = sacnUserName;
  }

  @JsonIgnore
  public ImageDataObj scanTime(String scanTime) {
    this.scanTime = scanTime;
    return this;
  }

   /**
   * 扫描时间
   * @return scanTime
  **/
  @ApiModelProperty(value = "扫描时间")
  public String getScanTime() {
    return scanTime;
  }

  public void setScanTime(String scanTime) {
    this.scanTime = scanTime;
  }

  @JsonIgnore
  public ImageDataObj imageInfo(List<ImageStructObj> imageInfo) {
    this.imageInfo = imageInfo;
    return this;
  }

  public ImageDataObj addImageInfoItem(ImageStructObj imageInfoItem) {
    this.imageInfo.add(imageInfoItem);
    return this;
  }

   /**
   * Get imageInfo
   * @return imageInfo
  **/
  @ApiModelProperty(value = "")
  public List<ImageStructObj> getImageInfo() {
    return imageInfo;
  }

  public void setImageInfo(List<ImageStructObj> imageInfo) {
    this.imageInfo = imageInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ImageDataObj imageDataObj = (ImageDataObj) o;
    return Objects.equals(this.tenantId, imageDataObj.tenantId) &&
        Objects.equals(this.imageId, imageDataObj.imageId) &&
        Objects.equals(this.imageType, imageDataObj.imageType) &&
        Objects.equals(this.imageUrl, imageDataObj.imageUrl) &&
        Objects.equals(this.sacnUserName, imageDataObj.sacnUserName) &&
        Objects.equals(this.scanTime, imageDataObj.scanTime) &&
        Objects.equals(this.imageInfo, imageDataObj.imageInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tenantId, imageId, imageType, imageUrl, sacnUserName, scanTime, imageInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ImageDataObj {\n");
    
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    imageId: ").append(toIndentedString(imageId)).append("\n");
    sb.append("    imageType: ").append(toIndentedString(imageType)).append("\n");
    sb.append("    imageUrl: ").append(toIndentedString(imageUrl)).append("\n");
    sb.append("    sacnUserName: ").append(toIndentedString(sacnUserName)).append("\n");
    sb.append("    scanTime: ").append(toIndentedString(scanTime)).append("\n");
    sb.append("    imageInfo: ").append(toIndentedString(imageInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
