package com.xforceplus.elephant.image.openapi.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 获取影像单据信息Request
 */
@ApiModel(description = "获取影像单据信息Request")

@JsonInclude(NON_NULL)
public class ImageDataRequest {
  @JsonProperty("tenantId")
  private String tenantId = null;

  @JsonProperty("billCode")
  private String billCode = null;

  @JsonProperty("sourceId")
  private String sourceId = null;

  @JsonIgnore
  public ImageDataRequest tenantId(String tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户ID
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户ID")
  public String getTenantId() {
    return tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public ImageDataRequest billCode(String billCode) {
    this.billCode = billCode;
    return this;
  }

   /**
   * 单据号
   * @return billCode
  **/
  @ApiModelProperty(value = "单据号")
  public String getBillCode() {
    return billCode;
  }

  public void setBillCode(String billCode) {
    this.billCode = billCode;
  }

  @JsonIgnore
  public ImageDataRequest sourceId(String sourceId) {
    this.sourceId = sourceId;
    return this;
  }

   /**
   * 调阅来源
   * @return sourceId
  **/
  @ApiModelProperty(value = "调阅来源")
  public String getSourceId() {
    return sourceId;
  }

  public void setSourceId(String sourceId) {
    this.sourceId = sourceId;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ImageDataRequest imageDataRequest = (ImageDataRequest) o;
    return Objects.equals(this.tenantId, imageDataRequest.tenantId) &&
        Objects.equals(this.billCode, imageDataRequest.billCode) &&
        Objects.equals(this.sourceId, imageDataRequest.sourceId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tenantId, billCode, sourceId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ImageDataRequest {\n");
    
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    billCode: ").append(toIndentedString(billCode)).append("\n");
    sb.append("    sourceId: ").append(toIndentedString(sourceId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
