package com.xforceplus.elephant.image.openapi.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 影像结构数据
 */
@ApiModel(description = "影像结构数据")

@JsonInclude(NON_NULL)
public class ImageStructObj {
  @JsonProperty("structType")
  private String structType = null;

  @JsonProperty("structJson")
  private Object structJson = null;

  @JsonIgnore
  public ImageStructObj structType(String structType) {
    this.structType = structType;
    return this;
  }

   /**
   * 结构数据类型
   * @return structType
  **/
  @ApiModelProperty(value = "结构数据类型")
  public String getStructType() {
    return structType;
  }

  public void setStructType(String structType) {
    this.structType = structType;
  }

  @JsonIgnore
  public ImageStructObj structJson(Object structJson) {
    this.structJson = structJson;
    return this;
  }

   /**
   * 结构数据
   * @return structJson
  **/
  @ApiModelProperty(value = "结构数据")
  public Object getStructJson() {
    return structJson;
  }

  public void setStructJson(Object structJson) {
    this.structJson = structJson;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ImageStructObj imageStructObj = (ImageStructObj) o;
    return Objects.equals(this.structType, imageStructObj.structType) &&
        Objects.equals(this.structJson, imageStructObj.structJson);
  }

  @Override
  public int hashCode() {
    return Objects.hash(structType, structJson);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ImageStructObj {\n");
    
    sb.append("    structType: ").append(toIndentedString(structType)).append("\n");
    sb.append("    structJson: ").append(toIndentedString(structJson)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
