package com.xforceplus.elephant.image.openapi.client.model;

import java.math.BigDecimal;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.Digits;

/**
 * 发票列表信息
 */
@ApiModel(description = "发票列表信息")

@JsonInclude(NON_NULL)
public class InvoiceList {

  @Length(max = 64, message = "【invoiceId】长度不能超过64")
  @JsonProperty("invoiceId")
  private String invoiceId = null;

  @Length(max = 64, message = "【imageId】长度不能超过64")
  @JsonProperty("imageId")
  private String imageId = null;

  @JsonProperty("usedAmount")
  private BigDecimal usedAmount = null;

  @JsonIgnore
  public InvoiceList invoiceId(String invoiceId) {
    this.invoiceId = invoiceId;
    return this;
  }

   /**
   * 发票Id
   * @return invoiceId
  **/
  @ApiModelProperty(value = "发票Id")
  public String getInvoiceId() {
    return invoiceId;
  }

  public void setInvoiceId(String invoiceId) {
    this.invoiceId = invoiceId;
  }

  @JsonIgnore
  public InvoiceList imageId(String imageId) {
    this.imageId = imageId;
    return this;
  }

   /**
   * 影像Id
   * @return imageId
  **/
  @ApiModelProperty(value = "影像Id")
  public String getImageId() {
    return imageId;
  }

  public void setImageId(String imageId) {
    this.imageId = imageId;
  }

  /**
   * 占用金额
   * @return usedAmount
   **/
  @ApiModelProperty(value = "占用金额")
  public BigDecimal getUsedAmount() {
    return usedAmount;
  }

  public void setUsedAmount(BigDecimal usedAmount) {
    this.usedAmount = usedAmount;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoiceList invoiceList = (InvoiceList) o;
    return Objects.equals(this.invoiceId, invoiceList.invoiceId)
            && Objects.equals(this.imageId, invoiceList.imageId)
            && Objects.equals(this.usedAmount, invoiceList.usedAmount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoiceId, imageId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoiceList {\n");
    
    sb.append("    invoiceId: ").append(toIndentedString(invoiceId)).append("\n");
    sb.append("    imageId: ").append(toIndentedString(imageId)).append("\n");
    sb.append("    usedAmount: ").append(toIndentedString(usedAmount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
