package com.xforceplus.elephant.image.openapi.client.model;

import java.io.Serializable;
import java.util.List;
import lombok.Data;

/**
 * 发票转移请求
 * @author rongying
 * @date 2023/4/4 16:37
 */
@Data
public class InvoiceTransferRequest implements Serializable {

    /**
     * 源用户代码
     */
    private String sourceUserCode;

    /**
     * 目标用户代码
     */
    private String targetUserCode;

    /**
     * 影像id集合
     */
    private List<String> imageIds;

    /**
     * 是否将现有用户的为挂接发票全部转移到新用户下:默认为 false。为 true 时，imageIds 不用填
     */
    private boolean transforAllFlag = false;

}
