package com.xforceplus.elephant.image.openapi.client.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Data;

/**
 * 发票转移返回值
 * @author rongying
 * @date 2023/4/12 17:08
 */
@Data
public class InvoiceTransferResult implements Serializable {

    private Integer totalCount;
    private Integer successCount;
    private Integer failedCount;
    private List<InvoiceTransferItem> success = new ArrayList<>();
    private List<InvoiceTransferItem> failed = new ArrayList<>();

    @Data
    @AllArgsConstructor
    public static class InvoiceTransferItem {
        private String imageId;
        private String message;
    }

}
