package com.xforceplus.elephant.image.openapi.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 日志
 */
@ApiModel(description = "日志")

@JsonInclude(NON_NULL)
public class LogApiObj {
  @JsonProperty("tenantId")
  private Long tenantId = null;

  @JsonProperty("number")
  private String number = null;

  @JsonProperty("billCode")
  private String billCode = null;

  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("methodCode")
  private String methodCode = null;

  @JsonProperty("systemType")
  private Integer systemType = null;

  @JsonProperty("sender")
  private String sender = null;

  @JsonProperty("receiver")
  private String receiver = null;

  @JsonProperty("methodUrl")
  private String methodUrl = null;

  @JsonProperty("methodName")
  private String methodName = null;

  @JsonProperty("methodDescription")
  private String methodDescription = null;

  @JsonProperty("params")
  private String params = null;

  @JsonProperty("result")
  private String result = null;

  @JsonProperty("isSuccess")
  private String isSuccess = null;

  @JsonProperty("isRetry")
  private Integer isRetry = null;

  @JsonProperty("exceptionDetail")
  private String exceptionDetail = null;

  @JsonProperty("executionTime")
  private String executionTime = null;

  @JsonProperty("createTime")
  private Long createTime = null;

  @JsonProperty("createUser")
  private String createUser = null;

  @JsonIgnore
  public LogApiObj tenantId(Long tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户ID
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户ID")
  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public LogApiObj number(String number) {
    this.number = number;
    return this;
  }

   /**
   * 流水号
   * @return number
  **/
  @ApiModelProperty(value = "流水号")
  public String getNumber() {
    return number;
  }

  public void setNumber(String number) {
    this.number = number;
  }

  @JsonIgnore
  public LogApiObj billCode(String billCode) {
    this.billCode = billCode;
    return this;
  }

   /**
   * 业务单号
   * @return billCode
  **/
  @ApiModelProperty(value = "业务单号")
  public String getBillCode() {
    return billCode;
  }

  public void setBillCode(String billCode) {
    this.billCode = billCode;
  }

  @JsonIgnore
  public LogApiObj invoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
    return this;
  }

   /**
   * 发票号码
   * @return invoiceNo
  **/
  @ApiModelProperty(value = "发票号码")
  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  @JsonIgnore
  public LogApiObj invoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
    return this;
  }

   /**
   * 发票代码
   * @return invoiceCode
  **/
  @ApiModelProperty(value = "发票代码")
  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  @JsonIgnore
  public LogApiObj methodCode(String methodCode) {
    this.methodCode = methodCode;
    return this;
  }

   /**
   * 方法code
   * @return methodCode
  **/
  @ApiModelProperty(value = "方法code")
  public String getMethodCode() {
    return methodCode;
  }

  public void setMethodCode(String methodCode) {
    this.methodCode = methodCode;
  }

  @JsonIgnore
  public LogApiObj systemType(Integer systemType) {
    this.systemType = systemType;
    return this;
  }

   /**
   * null
   * @return systemType
  **/
  @ApiModelProperty(value = "null")
  public Integer getSystemType() {
    return systemType;
  }

  public void setSystemType(Integer systemType) {
    this.systemType = systemType;
  }

  @JsonIgnore
  public LogApiObj sender(String sender) {
    this.sender = sender;
    return this;
  }

   /**
   * 调用方
   * @return sender
  **/
  @ApiModelProperty(value = "调用方")
  public String getSender() {
    return sender;
  }

  public void setSender(String sender) {
    this.sender = sender;
  }

  @JsonIgnore
  public LogApiObj receiver(String receiver) {
    this.receiver = receiver;
    return this;
  }

   /**
   * 提供方
   * @return receiver
  **/
  @ApiModelProperty(value = "提供方")
  public String getReceiver() {
    return receiver;
  }

  public void setReceiver(String receiver) {
    this.receiver = receiver;
  }

  @JsonIgnore
  public LogApiObj methodUrl(String methodUrl) {
    this.methodUrl = methodUrl;
    return this;
  }

   /**
   * 方法路径
   * @return methodUrl
  **/
  @ApiModelProperty(value = "方法路径")
  public String getMethodUrl() {
    return methodUrl;
  }

  public void setMethodUrl(String methodUrl) {
    this.methodUrl = methodUrl;
  }

  @JsonIgnore
  public LogApiObj methodName(String methodName) {
    this.methodName = methodName;
    return this;
  }

   /**
   * null
   * @return methodName
  **/
  @ApiModelProperty(value = "null")
  public String getMethodName() {
    return methodName;
  }

  public void setMethodName(String methodName) {
    this.methodName = methodName;
  }

  @JsonIgnore
  public LogApiObj methodDescription(String methodDescription) {
    this.methodDescription = methodDescription;
    return this;
  }

   /**
   * 方法描述信息
   * @return methodDescription
  **/
  @ApiModelProperty(value = "方法描述信息")
  public String getMethodDescription() {
    return methodDescription;
  }

  public void setMethodDescription(String methodDescription) {
    this.methodDescription = methodDescription;
  }

  @JsonIgnore
  public LogApiObj params(String params) {
    this.params = params;
    return this;
  }

   /**
   * 参数
   * @return params
  **/
  @ApiModelProperty(value = "参数")
  public String getParams() {
    return params;
  }

  public void setParams(String params) {
    this.params = params;
  }

  @JsonIgnore
  public LogApiObj result(String result) {
    this.result = result;
    return this;
  }

   /**
   * 结果
   * @return result
  **/
  @ApiModelProperty(value = "结果")
  public String getResult() {
    return result;
  }

  public void setResult(String result) {
    this.result = result;
  }

  @JsonIgnore
  public LogApiObj isSuccess(String isSuccess) {
    this.isSuccess = isSuccess;
    return this;
  }

   /**
   * 是否成功 0-默认 200- 成功 500-失败
   * @return isSuccess
  **/
  @ApiModelProperty(value = "是否成功 0-默认 200- 成功 500-失败")
  public String getIsSuccess() {
    return isSuccess;
  }

  public void setIsSuccess(String isSuccess) {
    this.isSuccess = isSuccess;
  }

  @JsonIgnore
  public LogApiObj isRetry(Integer isRetry) {
    this.isRetry = isRetry;
    return this;
  }

   /**
   * 是否重试 默认0  0-否 1-是
   * @return isRetry
  **/
  @ApiModelProperty(value = "是否重试 默认0  0-否 1-是")
  public Integer getIsRetry() {
    return isRetry;
  }

  public void setIsRetry(Integer isRetry) {
    this.isRetry = isRetry;
  }

  @JsonIgnore
  public LogApiObj exceptionDetail(String exceptionDetail) {
    this.exceptionDetail = exceptionDetail;
    return this;
  }

   /**
   * 异常信息
   * @return exceptionDetail
  **/
  @ApiModelProperty(value = "异常信息")
  public String getExceptionDetail() {
    return exceptionDetail;
  }

  public void setExceptionDetail(String exceptionDetail) {
    this.exceptionDetail = exceptionDetail;
  }

  @JsonIgnore
  public LogApiObj executionTime(String executionTime) {
    this.executionTime = executionTime;
    return this;
  }

   /**
   * 执行时长
   * @return executionTime
  **/
  @ApiModelProperty(value = "执行时长")
  public String getExecutionTime() {
    return executionTime;
  }

  public void setExecutionTime(String executionTime) {
    this.executionTime = executionTime;
  }

  @JsonIgnore
  public LogApiObj createTime(Long createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 创建时间
   * @return createTime
  **/
  @ApiModelProperty(value = "创建时间")
  public Long getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Long createTime) {
    this.createTime = createTime;
  }

  @JsonIgnore
  public LogApiObj createUser(String createUser) {
    this.createUser = createUser;
    return this;
  }

   /**
   * 创建人
   * @return createUser
  **/
  @ApiModelProperty(value = "创建人")
  public String getCreateUser() {
    return createUser;
  }

  public void setCreateUser(String createUser) {
    this.createUser = createUser;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LogApiObj logApiObj = (LogApiObj) o;
    return Objects.equals(this.tenantId, logApiObj.tenantId) &&
        Objects.equals(this.number, logApiObj.number) &&
        Objects.equals(this.billCode, logApiObj.billCode) &&
        Objects.equals(this.invoiceNo, logApiObj.invoiceNo) &&
        Objects.equals(this.invoiceCode, logApiObj.invoiceCode) &&
        Objects.equals(this.methodCode, logApiObj.methodCode) &&
        Objects.equals(this.systemType, logApiObj.systemType) &&
        Objects.equals(this.sender, logApiObj.sender) &&
        Objects.equals(this.receiver, logApiObj.receiver) &&
        Objects.equals(this.methodUrl, logApiObj.methodUrl) &&
        Objects.equals(this.methodName, logApiObj.methodName) &&
        Objects.equals(this.methodDescription, logApiObj.methodDescription) &&
        Objects.equals(this.params, logApiObj.params) &&
        Objects.equals(this.result, logApiObj.result) &&
        Objects.equals(this.isSuccess, logApiObj.isSuccess) &&
        Objects.equals(this.isRetry, logApiObj.isRetry) &&
        Objects.equals(this.exceptionDetail, logApiObj.exceptionDetail) &&
        Objects.equals(this.executionTime, logApiObj.executionTime) &&
        Objects.equals(this.createTime, logApiObj.createTime) &&
        Objects.equals(this.createUser, logApiObj.createUser);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tenantId, number, billCode, invoiceNo, invoiceCode, methodCode, systemType, sender, receiver, methodUrl, methodName, methodDescription, params, result, isSuccess, isRetry, exceptionDetail, executionTime, createTime, createUser);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LogApiObj {\n");
    
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    number: ").append(toIndentedString(number)).append("\n");
    sb.append("    billCode: ").append(toIndentedString(billCode)).append("\n");
    sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
    sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
    sb.append("    methodCode: ").append(toIndentedString(methodCode)).append("\n");
    sb.append("    systemType: ").append(toIndentedString(systemType)).append("\n");
    sb.append("    sender: ").append(toIndentedString(sender)).append("\n");
    sb.append("    receiver: ").append(toIndentedString(receiver)).append("\n");
    sb.append("    methodUrl: ").append(toIndentedString(methodUrl)).append("\n");
    sb.append("    methodName: ").append(toIndentedString(methodName)).append("\n");
    sb.append("    methodDescription: ").append(toIndentedString(methodDescription)).append("\n");
    sb.append("    params: ").append(toIndentedString(params)).append("\n");
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("    isSuccess: ").append(toIndentedString(isSuccess)).append("\n");
    sb.append("    isRetry: ").append(toIndentedString(isRetry)).append("\n");
    sb.append("    exceptionDetail: ").append(toIndentedString(exceptionDetail)).append("\n");
    sb.append("    executionTime: ").append(toIndentedString(executionTime)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    createUser: ").append(toIndentedString(createUser)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
