package com.xforceplus.elephant.image.openapi.client.model;

import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import lombok.Data;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

@Data
public class SaveAndHookRequest implements java.io.Serializable {

    @NotBlank(message = "【userCode】不能为空")
    @Length(max = 50, message = "【userCode】长度不能超过50")
    private String userCode;
    @NotBlank(message = "【isPublic】不能为空")
    @Pattern(regexp = "(0|1|2|3)", message = "【isPublic】的值必须在 0/1/2/3 之间")
    private String isPublic;
    @NotBlank(message = "【source】不能为空")
    @Length(max = 50, message = "【source】长度不能超过50")
    private String source;
    @Length(max = 50, message = "【bizOrderNo】长度不能超过50")
    private String bizOrderNo;
    @NotNull(message = "【operationType】不能为空")
    private OperationType operationType;
    @Size(max = 100, message = "单次请求最大支持100张发票")
    private List<Map<String, Object>> invoices;

    public enum OperationType {
        SAVE,
        DELETE;
    }

}
