package com.xforceplus.elephant.image.openapi.client.model;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;

import javax.validation.constraints.*;

/**
 * 保存影像文件Request
 */
@ApiModel(description = "保存影像文件Request")

@JsonInclude(NON_NULL)
public class SaveAuditFileRequest implements Serializable {
    @JsonProperty("tenantId")
    private String tenantId = null;

    @JsonProperty("tenantCode")
    private String tenantCode = null;


    @JsonProperty("userCode")
    private String userCode = null;

    @JsonProperty("billCode")
    private String billCode = null;

    @JsonProperty("fileOperationType")
    private String fileOperationType = null;

    @JsonProperty("files")
    private List<FileObj> files;

    @JsonProperty("coverBusinessFileType")
    private List<String> coverBusinessFileType;

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getTenantCode() {
        return tenantCode;
    }

    public void setTenantCode(String tenantCode) {
        this.tenantCode = tenantCode;
    }

    public String getUserCode() {
        return userCode;
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getFileOperationType() {
        return fileOperationType;
    }

    public void setFileOperationType(String fileOperationType) {
        this.fileOperationType = fileOperationType;
    }

    public List<FileObj> getFiles() {
        return files;
    }

    public void setFiles(List<FileObj> files) {
        this.files = files;
    }

    public List<String> getCoverBusinessFileType() {
        return coverBusinessFileType;
    }

    public void setCoverBusinessFileType(List<String> coverBusinessFileType) {
        this.coverBusinessFileType = coverBusinessFileType;
    }
}
