package com.xforceplus.elephant.image.openapi.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.Pattern;
import java.util.Map;

@ApiModel(description = "单据数据对象")
public class SaveBillDataDTO {

    @JsonProperty("tenantId")
    private String tenantId = null;

    @JsonProperty("tenantCode")
    private String tenantCode = null;

    @NotBlank(message = "【billCodeType】不能为空")
    @Length(max = 20, message = "【billCodeType】长度不能超过20")
    @JsonProperty("billCodeType")
    private String billCodeType = null;

    @NotBlank(message = "【billCode】不能为空")
    @Length(max = 64, message = "【billCode】长度不能超过64")
    @JsonProperty("billCode")
    private String billCode = null;

    @NotBlank(message = "【userCode】不能为空")
    @Length(max = 64, message = "【userCode】长度不能超过64")
    @JsonProperty("userCode")
    private String userId = null;

    @Length(max = 200, message = "【userName】长度不能超过200")
    @JsonProperty("userName")
    private String userName = null;

    @Length(max = 20, message = "【createTime】长度不能超过20")
    @JsonProperty("createTime")
    private String createTime = null;

    @Length(max = 20, message = "【amountWithTax】长度不能超过20")
    @JsonProperty("amountWithTax")
    private String totalAmount = "0";

    @Length(max = 20, message = "【taxAmount】长度不能超过20")
    @JsonProperty("taxAmount")
    private String taxAmount = "0";

    @Length(max = 20, message = "【amountWithoutTax】长度不能超过20")
    @JsonProperty("amountWithoutTax")
    private String amountWithoutTax = "0";

    @Length(max = 20, message = "【source】长度不能超过20")
    @JsonProperty("source")
    private String systemOrig = null;

    @Length(max = 500, message = "【remark】长度不能超过500")
    @JsonProperty("remark")
    private String remark = null;

    @JsonProperty("extFields")
    private Map<String, Object> extFields = null;

    @JsonProperty("orgCode")
    private String orgCode = null;

    //重庆医药专用
    @JsonProperty("billCodeSubType")
    private String billCodeSubType = null;


    @JsonProperty("isBusinessExpenses")
    private String isBusinessExpenses = null;

    //重庆医药专用
    @JsonProperty("isNeedScan")
    private String isNeedScan = "1";

    @Length(max = 200, message = "【buyerName】长度不能超过200")
    @JsonProperty("buyerName")
    private String purchaserName;


    @Length(max = 30, message = "【buyerTaxNo】长度不能超过30")
    @JsonProperty("buyerTaxNo")
    private String purchaserTaxNo;

    @Pattern(regexp = "^(0|1|2|3|4|5|6)?$", message = "【status】的值必须为空或者在 0/1/2/3/4/5/6 之间")
    @JsonProperty("status")
    private String status;

    @Length(max = 20, message = "【businessType】长度不能超过20")
    @JsonProperty("businessType")
    private String businessType;

    @Length(max = 64, message = "【settlementNo】长度不能超过64")
    @JsonProperty("settlementNo")
    private String settlementNo;

    @Length(max = 20, message = "【billUse】长度不能超过20")
    @JsonProperty("billUse")
    private String billUse;

    private Integer payStatus;

    @Length(max = 500, message = "【auditRemark】长度不能超过500")
    @JsonProperty("auditRemark")
    private String auditRemark;

    @Length(max = 4, message = "【settlementType】长度不能超过4")
    @JsonProperty("settlementType")
    private String settlementType;

    /**
     * 0否（默认值)会先脱挂再挂接 1是 直接追加挂接(单次请求限制100条)
     */
    @Length(max = 4, message = "【isAddHook】长度不能超过4")
    @JsonProperty("isAddHook")
    private String isAddHook = "0";

    /**
     * 1-挂接（默认），2-脱挂
     */
    @Length(max = 4, message = "【hookType】长度不能超过4")
    @JsonProperty("hookType")
    private String hookType = "1";

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getTenantCode() {
        return tenantCode;
    }

    public void setTenantCode(String tenantCode) {
        this.tenantCode = tenantCode;
    }

    public String getBillCodeType() {
        return billCodeType;
    }

    public void setBillCodeType(String billCodeType) {
        this.billCodeType = billCodeType;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(String totalAmount) {
        this.totalAmount = totalAmount;
    }

    public String getTaxAmount() {
        return taxAmount;
    }

    public void setTaxAmount(String taxAmount) {
        this.taxAmount = taxAmount;
    }

    public String getAmountWithoutTax() {
        return amountWithoutTax;
    }

    public void setAmountWithoutTax(String amountWithoutTax) {
        this.amountWithoutTax = amountWithoutTax;
    }

    public String getSystemOrig() {
        return systemOrig;
    }

    public void setSystemOrig(String systemOrig) {
        this.systemOrig = systemOrig;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Map<String, Object> getExtFields() {
        return extFields;
    }

    public void setExtFields(Map<String, Object> extFields) {
        this.extFields = extFields;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getBillCodeSubType() {
        return billCodeSubType;
    }

    public void setBillCodeSubType(String billCodeSubType) {
        this.billCodeSubType = billCodeSubType;
    }

    public String getIsBusinessExpenses() {
        return isBusinessExpenses;
    }

    public void setIsBusinessExpenses(String isBusinessExpenses) {
        this.isBusinessExpenses = isBusinessExpenses;
    }

    public String getIsNeedScan() {
        return isNeedScan;
    }

    public void setIsNeedScan(String isNeedScan) {
        this.isNeedScan = isNeedScan;
    }

    public String getPurchaserName() {
        return purchaserName;
    }

    public void setPurchaserName(String purchaserName) {
        this.purchaserName = purchaserName;
    }

    public String getPurchaserTaxNo() {
        return purchaserTaxNo;
    }

    public void setPurchaserTaxNo(String purchaserTaxNo) {
        this.purchaserTaxNo = purchaserTaxNo;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public String getSettlementNo() {
        return settlementNo;
    }

    public void setSettlementNo(String settlementNo) {
        this.settlementNo = settlementNo;
    }

    public String getBillUse() {
        return billUse;
    }

    public void setBillUse(String billUse) {
        this.billUse = billUse;
    }

    public Integer getPayStatus() {
        return payStatus;
    }

    public void setPayStatus(Integer payStatus) {
        this.payStatus = payStatus;
    }

    public String getAuditRemark() {
        return auditRemark;
    }

    public void setAuditRemark(String auditRemark) {
        this.auditRemark = auditRemark;
    }

    public String getSettlementType() {
        return settlementType;
    }

    public void setSettlementType(String settlementType) {
        this.settlementType = settlementType;
    }

    public String getIsAddHook() {
        return isAddHook;
    }

    public void setIsAddHook(String isAddHook) {
        this.isAddHook = isAddHook;
    }

    public String getHookType() {
        return hookType;
    }

    public void setHookType(String hookType) {
        this.hookType = hookType;
    }
}
