package com.xforceplus.elephant.image.openapi.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 保存单据Request
 */
@ApiModel(description = "保存单据Request")

@JsonInclude(NON_NULL)
public class SaveBillDataRequest {

  @JsonProperty("billMain")
  private BillMain billMain = null;

  @JsonProperty("invoiceList")
  private List<InvoiceList> invoiceList = new ArrayList<InvoiceList>();

  @JsonProperty("check")
  private boolean check = true;

  /**
   * 是否下发挂接的单证信息
   */
  @JsonProperty("autoRelationSync")
  private boolean autoRelationSync = false;

  @JsonIgnore
  public SaveBillDataRequest billMain(final BillMain billMain) {
    this.billMain = billMain;
    return this;
  }

  /**
   * Get billMain
   * @return billMain
  **/
  @ApiModelProperty(value = "")
  public BillMain getBillMain() {
    return billMain;
  }

  public void setBillMain(final BillMain billMain) {
    this.billMain = billMain;
  }

  @JsonIgnore
  public SaveBillDataRequest invoiceList(final List<InvoiceList> invoiceList) {
    this.invoiceList = invoiceList;
    return this;
  }

  public SaveBillDataRequest addInvoiceListItem(final InvoiceList invoiceListItem) {
    this.invoiceList.add(invoiceListItem);
    return this;
  }

   /**
   * 发票列表
   * @return invoiceList
  **/
  @ApiModelProperty(value = "发票列表")
  public List<InvoiceList> getInvoiceList() {
    return invoiceList;
  }

  public void setInvoiceList(final List<InvoiceList> invoiceList) {
    this.invoiceList = invoiceList;
  }


  @Override
  public boolean equals(final java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    final SaveBillDataRequest saveBillDataRequest = (SaveBillDataRequest) o;
    return Objects.equals(this.billMain, saveBillDataRequest.billMain) &&
        Objects.equals(this.invoiceList, saveBillDataRequest.invoiceList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(billMain, invoiceList);
  }


  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder();
    sb.append("class SaveBillDataRequest {\n");
    
    sb.append("    billMain: ").append(toIndentedString(billMain)).append("\n");
    sb.append("    invoiceList: ").append(toIndentedString(invoiceList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(final java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  public boolean isCheck() {
    return check;
  }

  public void setCheck(final boolean check) {
    this.check = check;
  }

  public boolean isAutoRelationSync() {
    return autoRelationSync;
  }

  public void setAutoRelationSync(final boolean autoRelationSync) {
    this.autoRelationSync = autoRelationSync;
  }

}
