package com.xforceplus.elephant.image.openapi.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 保存影像文件Request
 */
@ApiModel(description = "保存影像文件Request")

@JsonInclude(NON_NULL)
public class SaveFileRequest {
  @JsonProperty("tenantId")
  private String tenantId = null;

  @JsonProperty("serialNo")
  private String serialNo = null;

  @JsonProperty("billCodeType")
  private String billCodeType = null;

  @JsonProperty("billCode")
  private String billCode = null;

  @JsonProperty("userId")
  private String userId = null;

  @JsonProperty("companyId")
  private String companyId = null;

  @JsonProperty("systemOrig")
  private String systemOrig = null;

  @JsonProperty("streamFile")
  private String streamFile = null;

  @JsonProperty("fileType")
  private String fileType = null;

  @JsonIgnore
  public SaveFileRequest tenantId(String tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户ID
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户ID")
  public String getTenantId() {
    return tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public SaveFileRequest serialNo(String serialNo) {
    this.serialNo = serialNo;
    return this;
  }

   /**
   * 唯一键
   * @return serialNo
  **/
  @ApiModelProperty(value = "唯一键")
  public String getSerialNo() {
    return serialNo;
  }

  public void setSerialNo(String serialNo) {
    this.serialNo = serialNo;
  }

  @JsonIgnore
  public SaveFileRequest billCodeType(String billCodeType) {
    this.billCodeType = billCodeType;
    return this;
  }

   /**
   * 单据类型：1-对公，2-私，3-预付款
   * @return billCodeType
  **/
  @ApiModelProperty(value = "单据类型：1-对公，2-私，3-预付款")
  public String getBillCodeType() {
    return billCodeType;
  }

  public void setBillCodeType(String billCodeType) {
    this.billCodeType = billCodeType;
  }

  @JsonIgnore
  public SaveFileRequest billCode(String billCode) {
    this.billCode = billCode;
    return this;
  }

   /**
   * 单据号
   * @return billCode
  **/
  @ApiModelProperty(value = "单据号")
  public String getBillCode() {
    return billCode;
  }

  public void setBillCode(String billCode) {
    this.billCode = billCode;
  }

  @JsonIgnore
  public SaveFileRequest userId(String userId) {
    this.userId = userId;
    return this;
  }

   /**
   * 用户id
   * @return userId
  **/
  @ApiModelProperty(value = "用户id")
  public String getUserId() {
    return userId;
  }

  public void setUserId(String userId) {
    this.userId = userId;
  }

  @JsonIgnore
  public SaveFileRequest companyId(String companyId) {
    this.companyId = companyId;
    return this;
  }

   /**
   * 所属公司
   * @return companyId
  **/
  @ApiModelProperty(value = "所属公司")
  public String getCompanyId() {
    return companyId;
  }

  public void setCompanyId(String companyId) {
    this.companyId = companyId;
  }

  @JsonIgnore
  public SaveFileRequest systemOrig(String systemOrig) {
    this.systemOrig = systemOrig;
    return this;
  }

   /**
   * 系统来源
   * @return systemOrig
  **/
  @ApiModelProperty(value = "系统来源")
  public String getSystemOrig() {
    return systemOrig;
  }

  public void setSystemOrig(String systemOrig) {
    this.systemOrig = systemOrig;
  }

  @JsonIgnore
  public SaveFileRequest streamFile(String streamFile) {
    this.streamFile = streamFile;
    return this;
  }

   /**
   * 流文件
   * @return streamFile
  **/
  @ApiModelProperty(value = "流文件")
  public String getStreamFile() {
    return streamFile;
  }

  public void setStreamFile(String streamFile) {
    this.streamFile = streamFile;
  }

  @JsonIgnore
  public SaveFileRequest fileType(String fileType) {
    this.fileType = fileType;
    return this;
  }

   /**
   * 文件类型
   * @return fileType
  **/
  @ApiModelProperty(value = "文件类型")
  public String getFileType() {
    return fileType;
  }

  public void setFileType(String fileType) {
    this.fileType = fileType;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SaveFileRequest saveFileRequest = (SaveFileRequest) o;
    return Objects.equals(this.tenantId, saveFileRequest.tenantId) &&
        Objects.equals(this.serialNo, saveFileRequest.serialNo) &&
        Objects.equals(this.billCodeType, saveFileRequest.billCodeType) &&
        Objects.equals(this.billCode, saveFileRequest.billCode) &&
        Objects.equals(this.userId, saveFileRequest.userId) &&
        Objects.equals(this.companyId, saveFileRequest.companyId) &&
        Objects.equals(this.systemOrig, saveFileRequest.systemOrig) &&
        Objects.equals(this.streamFile, saveFileRequest.streamFile) &&
        Objects.equals(this.fileType, saveFileRequest.fileType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tenantId, serialNo, billCodeType, billCode, userId, companyId, systemOrig, streamFile, fileType);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SaveFileRequest {\n");
    
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    serialNo: ").append(toIndentedString(serialNo)).append("\n");
    sb.append("    billCodeType: ").append(toIndentedString(billCodeType)).append("\n");
    sb.append("    billCode: ").append(toIndentedString(billCode)).append("\n");
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    companyId: ").append(toIndentedString(companyId)).append("\n");
    sb.append("    systemOrig: ").append(toIndentedString(systemOrig)).append("\n");
    sb.append("    streamFile: ").append(toIndentedString(streamFile)).append("\n");
    sb.append("    fileType: ").append(toIndentedString(fileType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
