package com.xforceplus.elephant.image.openapi.client.model;

/**
 * @author yuhongxia
 * @description 保存影像和增值税发票
 * @date 2021/5/7 14:09
 */

import io.swagger.annotations.ApiModel;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import lombok.Data;

/**
 * 保存单证Request
 *
 * @author yuhongxia
 */
@Data
@ApiModel(description = "保存单证Request")
public class SaveTicketInvoiceRequest implements Serializable {

    /**
     * 租户id
     */
    private String tenantId;

    /**
     * 租户code
     */
    private String tenantCode;

    /**
     * 是否公共
     */
    private String isPublic;

    /**
     * 来源
     */
    private String imageSource;

    /**
     * 是否公共
     */
    private String createUserId;

    /**
     * 是否公共
     */
    private String createUserName;

    /**
     * 发票代码
     */
    private String invoiceCode;
    /**
     * 发票号码
     */
    private String invoiceNo;
    /**
     * 开票时间
     */
    private String invoiceTime;
    /**
     * 含税总金额(单位元)
     */
    private String totalAmount;
    /**
     * 总税额(单位元)
     */
    private String totalTax;
    /**
     * 机器码
     */
    private String machineCode;
    /**
     * 密文
     */
    private List<String> cipherList;
    /**
     * 购销方信息
     */
    private PurchaserSellerDTO purchaserSeller;
    /**
     * 校验码
     */
    private String checkCode;
    /**
     * 收款人
     */
    private String payee;
    /**
     * 复核
     */
    private String recheck;
    /**
     * 开票人
     */
    private String drawer;
    /**
     * 开票备注
     */
    private String remark;
    /**
     * 发票影像地址
     */
    private String imagUrl;
    /**
     * 发票pdf地址
     */
    private String pdfUrl;

    /**
     * tranceId
     */
    private String traceId;

    /**
     * 控制识别后是否触发验真，默认会触发 0 不验真
     */
    private Map<String, Object> ext;

}
