package com.xforceplus.elephant.image.openapi.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 保存单证Request
 */
@ApiModel(description = "保存单证Request")

@JsonInclude(NON_NULL)
public class SaveTicketObj {
  @JsonProperty("tenantId")
  private String tenantId = null;

  @JsonProperty("tenantCode")
  private String tenantCode = null;

  @JsonProperty("userName")
  private String userName;

  @JsonProperty("userId")
  private String userId;

  @JsonProperty("userCode")
  private String userCode;

  private String isPublic;

  @JsonProperty("invoiceMain")
  private String invoiceMain = null;

  @JsonProperty("invoiceDetails")
  private List<String> invoiceDetails = new ArrayList<>();

  @JsonProperty("ticketAttachment")
  private List<String> ticketAttachment = new ArrayList<>();

  @JsonProperty("ticketSalesList")
  private List<String> ticketSalesList = new ArrayList<>();

  @JsonProperty("businessKey")
  private String businessKey;

  @JsonProperty("isNeedPublish")
  private String isNeedPublish;

  public String getBusinessKey() {
    return businessKey;
  }

  public void setBusinessKey(String businessKey) {
    this.businessKey = businessKey;
  }

  public String getTenantId() {
    return tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  public String getTenantCode() {
    return tenantCode;
  }

  public void setTenantCode(String tenantCode) {
    this.tenantCode = tenantCode;
  }

  public String getUserName() {
    return userName;
  }

  public void setUserName(String userName) {
    this.userName = userName;
  }

  public String getUserId() {
    return userId;
  }

  public void setUserId(String userId) {
    this.userId = userId;
  }

  public String getIsPublic() {
    return isPublic;
  }

  public void setIsPublic(String isPublic) {
    this.isPublic = isPublic;
  }

  public String getInvoiceMain() {
    return invoiceMain;
  }

  public void setInvoiceMain(String invoiceMain) {
    this.invoiceMain = invoiceMain;
  }

  public List<String> getInvoiceDetails() {
    return invoiceDetails;
  }

  public void setInvoiceDetails(List<String> invoiceDetails) {
    this.invoiceDetails = invoiceDetails;
  }

  public List<String> getTicketAttachment() {
    return ticketAttachment;
  }

  public void setTicketAttachment(List<String> ticketAttachment) {
    this.ticketAttachment = ticketAttachment;
  }

  public List<String> getTicketSalesList() {
    return ticketSalesList;
  }

  public void setTicketSalesList(List<String> ticketSalesList) {
    this.ticketSalesList = ticketSalesList;
  }

  public String getUserCode() {
    return userCode;
  }

  public void setUserCode(String userCode) {
    this.userCode = userCode;
  }

  public String getIsNeedPublish() {
    return isNeedPublish;
  }

  public void setIsNeedPublish(String isNeedPublish) {
    this.isNeedPublish = isNeedPublish;
  }

}
