package com.xforceplus.elephant.image.openapi.client.model;


import com.google.api.client.util.Lists;

import java.io.Serializable;
import java.util.List;

/**
 * 示例：
 * a=1 and b=2--> {"root":{"type":"and","conditions":[{"field":"a","value":1,"operation":"eq"},{"field":"b","value":2,"operation":"eq"}]}}
 * a=1 or b=2--> {"root":{"type":"or","conditions":[{"field":"a","value":1,"operation":"eq"},{"field":"b","value":2,"operation":"eq"}]}}
 * a=1 and b=2 and (c=3 or d=4)--> {"root":{"type":"and","conditions":[{"field":"a","value":1,"operation":"eq"},{"field":"b","value":2,"operation":"eq"}],
 * "children":[{"type":"or","conditions":[{"field":"c","value":3,"operation":"eq"},{"field":"d","value":4,"operation":"eq"}]}]}}
 *
 *(a=1 and b=2) or (c=3 and d=4) -->  {"root":{"type":"or","conditions":[],"children":[{"type":"and","conditions":[{"field":"a","value":1,"operation":"eq"},
 * {"field":"b","value":2,"operation":"eq"}]},"type":"and","conditions":[{"field":"c","value":3,"operation":"eq"},{"field":"d","value":4,"operation":"eq"}]}]}}
 *
 * a=1 and b=2 and(c=3 or (d=4 and e=5)) -->
 * {
 *     "root":{
 *         "type":"and",
 *         "conditions":[{"field":"a","value":1,"operation":"eq"},{"field":"b","value":2,"operation":"eq"}],
 *         "children":[
 *              {
     *              “type”:"or",
     *              "conditions":[],
     *              "children":[
     *                   {"type":"and",
     *                   "conditions":[{"field":"c","value":3,"operation":"eq"}],
     *                   “children”:[]
 *                      },
 *                      {"type":"and",
 *      *                   "conditions":[{"field":"d","value":4,"operation":"eq"},{"field":"e","value":5,"operation":"eq"}],
 *      *                   “children”:[]
 *  *                   }
     *              ]
 *              }
 *
 *         ]
 *     }
 * }
 */
public class SimpleQueryRequest implements Serializable {

    private ConditionGroup root;

    private List<Sort> sorts;

    private Integer pageNo = 1;
    private Integer pageSize = 20;

    public SimpleQueryRequest init(){
        this.sorts = Lists.newArrayList();
        setSorts(Lists.newArrayList());
        return this;
    }
    public SimpleQueryRequest root(String groupType){
        root = new ConditionGroup();
        root.setType(groupType);
        setRoot(root);
        return this;
    }
    public SimpleQueryRequest field(String field, String operation, Object value){
        this.getRoot().getConditions().add(new Condition(field,operation,value));
        return this;
    }

    public SimpleQueryRequest child(ConditionGroup child){
        this.getRoot().getChildren().add(child);
        return this;
    }

    public SimpleQueryRequest sorts(String field, String sortType){
        this.getSorts().add(new Sort(field,sortType));
        return this;
    }

    public SimpleQueryRequest pageNo(Integer pageNo){
        this.pageNo = pageNo;
        return this;
    }

    public SimpleQueryRequest pageSize(Integer pageSize){
        this.pageSize = pageSize;
        return this;
    }


    public ConditionGroup getRoot() {
        return root;
    }

    public List<Sort> getSorts() {
        return sorts;
    }

    public Integer getPageNo() {
        return pageNo;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setRoot(ConditionGroup root) {
        this.root = root;
    }

    public void setSorts(List<Sort> sorts) {
        this.sorts = sorts;
    }

    public void setPageNo(Integer pageNo) {
        this.pageNo = pageNo;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }
}
