package com.xforceplus.elephant.image.openapi.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.*;

/**
 * 单据状态变更Request
 */
@ApiModel(description = "单据状态变更Request")

@JsonInclude(NON_NULL)
public class UpdateBillStatusRequest {
  @JsonProperty("tenantId")
  private String tenantId = null;

  @NotBlank(message = "【billCode】不能为空")
  @Length(max = 64, message = "【billCode】长度不能超过64")
  @JsonProperty("billCode")
  private String billCode = null;

  @JsonProperty("billCodeType")
  private String billCodeType = null;

  @NotBlank(message = "【status】不能为空")
  @Pattern(regexp = "(0|1|2|3|99)", message = "【status】的值必须在 0/1/2/3/99 之间")
  @JsonProperty("status")
  private String status = null;

  @Length(max = 4, message = "【commitStatus】长度不能超过4")
  @JsonProperty("commitStatus")
  private String commitStatus = "";

  @JsonProperty("workflowId")
  private String workflowId = null;

  @Length(max = 4, message = "【handleType】长度不能超过4")
  @JsonProperty("handleType")
  private String handleType = null;

  @JsonProperty("handleRemark")
  private String handleRemark = null;

  @JsonProperty("systemOrig")
  private String systemOrig = null;

  @JsonProperty("userId")
  private String userId = null;

  @JsonProperty("receiverName")
  private String receiverName = null;

  @JsonProperty("receiverAddress")
  private String receiverAddress = null;

  @JsonProperty("receiverTel")
  private String receiverTel = null;

  @JsonProperty("userCode")
  private String userCode = null;

  @JsonIgnore
  public UpdateBillStatusRequest tenantId(String tenantId) {
    this.tenantId = tenantId;
    return this;
  }

  public String getCommitStatus() {
    return commitStatus;
  }

  public void setCommitStatus(String commitStatus) {
    this.commitStatus = commitStatus;
  }

  /**
   * 租户ID
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户ID")
  public String getTenantId() {
    return tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public UpdateBillStatusRequest billCode(String billCode) {
    this.billCode = billCode;
    return this;
  }

   /**
   * 单据号
   * @return billCode
  **/
  @ApiModelProperty(value = "单据号")
  public String getBillCode() {
    return billCode;
  }

  public void setBillCode(String billCode) {
    this.billCode = billCode;
  }

  @JsonIgnore
  public UpdateBillStatusRequest billCodeType(String billCodeType) {
    this.billCodeType = billCodeType;
    return this;
  }

   /**
   * 业务单据类型：1-对公，2-私，3-对公预付款，4-对私预付款
   * @return billCodeType
  **/
  @ApiModelProperty(value = "业务单据类型：1-对公，2-私，3-对公预付款，4-对私预付款")
  public String getBillCodeType() {
    return billCodeType;
  }

  public void setBillCodeType(String billCodeType) {
    this.billCodeType = billCodeType;
  }

  @JsonIgnore
  public UpdateBillStatusRequest status(String status) {
    this.status = status;
    return this;
  }

   /**
   * 状态：（0-已提交，1-驳回，2-审核完成，3-已作废）
   * @return status
  **/
  @ApiModelProperty(value = "状态：（0-已提交，1-驳回，2-审核完成，3-已作废）")
  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  @JsonIgnore
  public UpdateBillStatusRequest workflowId(String workflowId) {
    this.workflowId = workflowId;
    return this;
  }

   /**
   * 流程编号
   * @return workflowId
  **/
  @ApiModelProperty(value = "流程编号")
  public String getWorkflowId() {
    return workflowId;
  }

  public void setWorkflowId(String workflowId) {
    this.workflowId = workflowId;
  }

  @JsonIgnore
  public UpdateBillStatusRequest handleType(String handleType) {
    this.handleType = handleType;
    return this;
  }

   /**
   * 处理方式:0-默认，1-邮寄，2-自取，3-重新扫描
   * @return handleType
  **/
  @ApiModelProperty(value = "处理方式:0-默认，1-邮寄，2-自取，3-重新扫描")
  public String getHandleType() {
    return handleType;
  }

  public void setHandleType(String handleType) {
    this.handleType = handleType;
  }

  @JsonIgnore
  public UpdateBillStatusRequest handleRemark(String handleRemark) {
    this.handleRemark = handleRemark;
    return this;
  }

   /**
   * 备注说明
   * @return handleRemark
  **/
  @ApiModelProperty(value = "备注说明")
  public String getHandleRemark() {
    return handleRemark;
  }

  public void setHandleRemark(String handleRemark) {
    this.handleRemark = handleRemark;
  }

  @JsonIgnore
  public UpdateBillStatusRequest systemOrig(String systemOrig) {
    this.systemOrig = systemOrig;
    return this;
  }

   /**
   * 系统来源：1-EPM，2-每刻
   * @return systemOrig
  **/
  @ApiModelProperty(value = "系统来源：1-EPM，2-每刻")
  public String getSystemOrig() {
    return systemOrig;
  }

  public void setSystemOrig(String systemOrig) {
    this.systemOrig = systemOrig;
  }

  @JsonIgnore
  public UpdateBillStatusRequest userId(String userId) {
    this.userId = userId;
    return this;
  }

   /**
   * 操作用户
   * @return userId
  **/
  @ApiModelProperty(value = "操作用户")
  public String getUserId() {
    return userId;
  }

  public void setUserId(String userId) {
    this.userId = userId;
  }

  @JsonIgnore
  public UpdateBillStatusRequest receiverName(String receiverName) {
    this.receiverName = receiverName;
    return this;
  }

   /**
   * 收件人
   * @return receiverName
  **/
  @ApiModelProperty(value = "收件人")
  public String getReceiverName() {
    return receiverName;
  }

  public void setReceiverName(String receiverName) {
    this.receiverName = receiverName;
  }

  @JsonIgnore
  public UpdateBillStatusRequest receiverAddress(String receiverAddress) {
    this.receiverAddress = receiverAddress;
    return this;
  }

   /**
   * 收件地址
   * @return receiverAddress
  **/
  @ApiModelProperty(value = "收件地址")
  public String getReceiverAddress() {
    return receiverAddress;
  }

  public void setReceiverAddress(String receiverAddress) {
    this.receiverAddress = receiverAddress;
  }

  @JsonIgnore
  public UpdateBillStatusRequest receiverTel(String receiverTel) {
    this.receiverTel = receiverTel;
    return this;
  }

   /**
   * 联系电话
   * @return receiverTel
  **/
  @ApiModelProperty(value = "联系电话")
  public String getReceiverTel() {
    return receiverTel;
  }

  public void setReceiverTel(String receiverTel) {
    this.receiverTel = receiverTel;
  }

  @JsonIgnore
  public UpdateBillStatusRequest userCode(String userCode) {
    this.userCode = userCode;
    return this;
  }

  /**
   * 用户代码
   * @return userCode
   **/
  @ApiModelProperty(value = "用户代码")
  public String getUserCode() {
    return userCode;
  }

  public void setUserCode(String userCode) {
    this.userCode = userCode;
  }



  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpdateBillStatusRequest updateBillStatusRequest = (UpdateBillStatusRequest) o;
    return Objects.equals(this.tenantId, updateBillStatusRequest.tenantId) &&
        Objects.equals(this.billCode, updateBillStatusRequest.billCode) &&
        Objects.equals(this.billCodeType, updateBillStatusRequest.billCodeType) &&
        Objects.equals(this.status, updateBillStatusRequest.status) &&
        Objects.equals(this.workflowId, updateBillStatusRequest.workflowId) &&
        Objects.equals(this.handleType, updateBillStatusRequest.handleType) &&
        Objects.equals(this.handleRemark, updateBillStatusRequest.handleRemark) &&
        Objects.equals(this.systemOrig, updateBillStatusRequest.systemOrig) &&
        Objects.equals(this.userId, updateBillStatusRequest.userId) &&
        Objects.equals(this.receiverName, updateBillStatusRequest.receiverName) &&
        Objects.equals(this.receiverAddress, updateBillStatusRequest.receiverAddress) &&
        Objects.equals(this.receiverTel, updateBillStatusRequest.receiverTel) &&
        Objects.equals(this.userCode, updateBillStatusRequest.userCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tenantId, billCode, billCodeType, status, workflowId, handleType, handleRemark, systemOrig, userId, receiverName, receiverAddress, receiverTel, userCode);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpdateBillStatusRequest {\n");

    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    billCode: ").append(toIndentedString(billCode)).append("\n");
    sb.append("    billCodeType: ").append(toIndentedString(billCodeType)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    workflowId: ").append(toIndentedString(workflowId)).append("\n");
    sb.append("    handleType: ").append(toIndentedString(handleType)).append("\n");
    sb.append("    handleRemark: ").append(toIndentedString(handleRemark)).append("\n");
    sb.append("    systemOrig: ").append(toIndentedString(systemOrig)).append("\n");
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    receiverName: ").append(toIndentedString(receiverName)).append("\n");
    sb.append("    receiverAddress: ").append(toIndentedString(receiverAddress)).append("\n");
    sb.append("    receiverTel: ").append(toIndentedString(receiverTel)).append("\n");
    sb.append("    userCode: ").append(toIndentedString(userCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
