package com.xforceplus.elephant.image.openapi.client.model;

import java.util.Map;
import lombok.Data;

/**
 * 更新单证请求
 *
 * @author liuhongbin
 * @date 2021/12/2 17:26
 */
@Data
public class UpdateTicketRequest {

    /**
     * 单据号
     */
    private String billCode;
    /**
     * 影像id
     */
    private String[] imageId;
    /**
     * 租户id
     */
    private String tenantId;

    /**
     * 租户代码
     */
    private String tenantCode;

    /**
     * 发票id数组
     */
    private String[] ids;

    /**
     * 发票类型
     */
    private String invoiceType;

    /**
     * 发票代码
     */
    private String invoiceCode;

    /**
     * 发票号码
     */
    private String invoiceNo;

    /**
     * 用户id
     */
    private String userId;

    /**
     * 用户名
     */
    private String userName;

    /**
     * 用户code
     */
    private String userCode;

    /**
     * 记账状态
     */
    private String chargeUpStatus;

    /**
     * 记账日期
     */
    private String chargeUpPeriod;

    /**
     * 记账单号
     */
    private String chargeUpNo;

    /**
     * 记账金额
     */
    private String chargeUpAmount;

    /**
     * 记账人
     */
    private String chargeUpPerson;

    /**
     * 付款状态
     */
    private String paymentStatus;

    /**
     * 付款日期
     */
    private String paymentDate;

    /**
     * 付款单号
     */
    private String paymentNo;

    /**
     * 付款金额
     */
    private String paymentAmount;

    /**
     * 付款人姓名
     */
    private String paymentUserName;

    /**
     * 签收状态：0-空，1-未签收，2-已签收
     */
    private String signForStatus;

    /**
     * 购方税号
     */
    private String purchaserTaxNo;

    /**
     * 扩展字段
     */
    private Map<String, Object> extFields;

    /**
     * 保留字段
     */
    private Map<String, Object> reviewFields;

    /**
     * 0-未报销，1-报销中，-1-报销失败， 2-报销成功
     */
    private String reimbursementStatus;

    /**
     * 报销时间
     */
    private String reimbursementTime;

}
