package com.xforceplus.elephant.image.openapi.client.model.hook;

import com.xforceplus.elephant.image.openapi.client.validator.ValidatorConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import lombok.Data;

@Data
public class BillAndInvoiceHookRelationParamDTO implements java.io.Serializable {

    @NotBlank(message = "【billCode】不能为空")
    private String billCode;

    @NotBlank(message = "【billCodeType】不能为空")
    private String billCodeType;

    private String businessType;

    @Pattern(regexp = "^(0|1|2|3|4|5|6)?$", message = "【status】的值必须在 0/1/2/3/4/5/6 之间")
    private String status;

    @Pattern(regexp = "^(1|2|3)?$", message = "【hookType】的值必须在 1/2/3 之间")
    private String hookType;

    @NotBlank(message = "【userCode】不能为空")
    private String userCode;

    private String userName;

    private String createTime;

    @Pattern(regexp = ValidatorConstants.AMOUNT_REGEX, message = "【amountWithTax】必须是金额")
    private String amountWithTax;

    @Pattern(regexp = ValidatorConstants.AMOUNT_REGEX, message = "【taxAmount】必须是金额")
    private String taxAmount;

    @Pattern(regexp = ValidatorConstants.AMOUNT_REGEX, message = "【amountWithoutTax】必须是金额")
    private String amountWithoutTax;

    private String remark;

    private String source;

    private String buyerName;

    private String buyerTaxNo;

    private String settlementNo;

    private Map<String, Object> extFields = new HashMap<>();

    @Pattern(regexp = "^(1|2)?$", message = "【isAddHook】的值必须在 1/2 之间")
    private String isAddHook;

    private List<BillAndInvoiceHookRelationInvoiceParamDTO> invoices = new ArrayList<>();
}