/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.log;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.annotation.LogApi;
import com.xforceplus.elephant.basecommon.baseconst.MqConst;
import com.xforceplus.elephant.basecommon.help.JsonHelp;
import com.xforceplus.elephant.basecommon.help.StringHelp;
import com.xforceplus.elephant.basecommon.log.LogApiEntity;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.support.CorrelationData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class LogAspect {
    @Autowired
    private RabbitTemplate rabbitTemplate;
    private String directExchange = "DIRECT_EXCHANGE";
    private long executionTime;

    @Pointcut(value="@annotation(com.xforceplus.elephant.basecommon.annotation.LogApi)")
    public void logPoint() {
    }

    @Before(value="logPoint() && @annotation(logApi)")
    public void doBefore(JoinPoint joinPoint) {
    }

    @Around(value="logPoint()")
    public void aroundMethod(JoinPoint joinPoint) {
        long start = System.currentTimeMillis();
        try {
            ((ProceedingJoinPoint)joinPoint).proceed();
            long end = System.currentTimeMillis();
            System.out.println("around " + joinPoint + "\t\u8017\u65f6 : " + (end - start) + " ms!");
            this.executionTime = end - start;
        }
        catch (Throwable e) {
            long end = System.currentTimeMillis();
            System.out.println("around " + joinPoint + "\t \u8017\u65f6 : " + (end - start) + " ms \u5f02\u5e38\u4fe1\u606f : " + e.getMessage());
            this.executionTime = end - start;
        }
    }

    @After(value="logPoint()")
    public void afterRun(JoinPoint joinPoint) {
        try {
            String params = "";
            if (joinPoint.getArgs() != null && joinPoint.getArgs().length > 0) {
                for (int i = 0; i < joinPoint.getArgs().length; ++i) {
                    params = params + JsonHelp.toString(joinPoint.getArgs()[i]) + ";";
                }
            }
            String targetName = joinPoint.getTarget().getClass().getName();
            String methodName = joinPoint.getSignature().getName();
            Object[] arguments = joinPoint.getArgs();
            Class<?> targetClass = Class.forName(targetName);
            Method[] methods = targetClass.getMethods();
            String methodUrl = "";
            String methodDescription = "";
            String annotationMethodName = "";
            String sender = "";
            String receiver = "";
            for (Method method : methods) {
                Class<?>[] clazzs;
                if (!method.getName().equals(methodName) || (clazzs = method.getParameterTypes()).length != arguments.length) continue;
                methodUrl = method.getAnnotation(LogApi.class).methodUrl();
                methodDescription = method.getAnnotation(LogApi.class).methodDescription();
                annotationMethodName = method.getAnnotation(LogApi.class).methodName();
                sender = method.getAnnotation(LogApi.class).sender();
                receiver = method.getAnnotation(LogApi.class).receiver();
                break;
            }
            LogApiEntity logApiEntity = new LogApiEntity();
            logApiEntity.setCreateTime(new Date());
            logApiEntity.setCreateUser("\u7cfb\u7edf");
            logApiEntity.setIssuccess(200);
            logApiEntity.setMethodName(annotationMethodName);
            logApiEntity.setMethodDescription(methodDescription);
            logApiEntity.setMethodUrl(methodUrl);
            logApiEntity.setExecutionTime(StringHelp.safeToString(this.executionTime));
            logApiEntity.setSender(sender);
            logApiEntity.setReceiver(receiver);
            HashMap<String, LogApiEntity> map = new HashMap<String, LogApiEntity>();
            map.put("msg", logApiEntity);
            String message = JSONObject.toJSONString(map);
            this.rabbitTemplate.convertAndSend(MqConst.DIRECT_EXCHANGE, "logMq", (Object)message, new CorrelationData(UUID.randomUUID().toString()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

