/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.process.response;

public class CommonResponse<T> {
    public static final Integer OK = 1;
    public static final Integer Fail = 0;
    private Integer code;
    private String message;
    private T result;

    public static CommonResponse ok(String message) {
        return CommonResponse.ok(message, null);
    }

    public static <T> CommonResponse<T> ok(String message, T result) {
        return CommonResponse.from(OK, message, result);
    }

    public static CommonResponse failed(String message) {
        return CommonResponse.from(Fail, message);
    }

    public static CommonResponse from(Integer code, String message) {
        return CommonResponse.from(code, message, null);
    }

    public static <T> CommonResponse<T> from(Integer code, String message, T result) {
        CommonResponse<T> response = new CommonResponse<T>();
        response.setCode(code);
        response.setMessage(message);
        response.setResult(result);
        return response;
    }

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getResult() {
        return this.result;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public String toString() {
        return "CommonResponse{code=" + this.code + ", message='" + this.message + '\'' + ", result=" + this.result + '}';
    }
}

