/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.system.pass;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.help.HttpUtils;
import com.xforceplus.elephant.basecommon.help.StringHelp;
import com.xforceplus.elephant.basecommon.system.pass.PassTokenUtils;
import com.xforceplus.elephant.basecommon.system.pass.SystemPassSettings;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LogisticsUtils {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SystemPassSettings systemPassSettings;
    @Autowired
    private PassTokenUtils passTokenUtils;
    private static final String tenantUrl = "/api/";

    public String getLogisticsInfo(String tenantId, String appId, String expressCode, String parcelNo) {
        String result = "";
        JSONObject json = new JSONObject();
        json.put("code", (Object)-1);
        json.put("result", (Object)result);
        try {
            result = this.vaildateTrackParam(tenantId, appId, expressCode, parcelNo);
            if (!StringHelp.safeIsEmpty(result)) {
                json.put("message", (Object)result);
                return JSON.toJSONString((Object)json);
            }
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("appId", appId);
            paramMap.put("expressCode", expressCode);
            paramMap.put("waybillNo", parcelNo);
            String token = this.passTokenUtils.getLoginToken();
            HashMap<String, String> headerParam = new HashMap<String, String>();
            headerParam.put("x-app-token", token);
            String url = this.systemPassSettings.getBaseUrl() + tenantUrl + tenantId + this.systemPassSettings.getLogisticsTrackUrl();
            this.logger.debug("\u67e5\u8be2\u7269\u6d41\u8f68\u8ff9\u4fe1\u606f\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u5165\u53c2\uff1a{}", new Object[]{tenantId, url, JSON.toJSONString(paramMap)});
            result = HttpUtils.doGet(url, headerParam, paramMap);
            JSONObject resultObject = JSONObject.parseObject((String)result);
            String respCode = resultObject.getString("code");
            String respMsg = resultObject.getString("message");
            String value = resultObject.getString("result");
            if (!"LGSTZZ0200".equals(respCode) || "[]".equals(value)) {
                json.put("message", (Object)("\u7269\u6d41\u8f68\u8ff9\u67e5\u8be2\u5931\u8d25\uff1a" + respMsg));
                return JSON.toJSONString((Object)json);
            }
            this.logger.debug("\u7269\u6d41\u8f68\u8ff9\u67e5\u8be2\u6210\u529f\uff1a" + result);
            json.put("code", (Object)1);
            json.put("message", (Object)"\u7269\u6d41\u8f68\u8ff9\u67e5\u8be2\u6210\u529f");
            json.put("result", (Object)value);
            return JSON.toJSONString((Object)json);
        }
        catch (Exception e) {
            json.put("message", (Object)e.getMessage());
            this.logger.error("\u67e5\u8be2\u7269\u6d41\u8f68\u8ff9\u4fe1\u606f\u5f02\u5e38\uff0c\u79df\u6237ID\uff1a{}\uff0c\u5f02\u5e38\u539f\u56e0\uff1a{}", (Object)tenantId, (Object)e.getMessage());
            return JSON.toJSONString((Object)json);
        }
    }

    public String createLogisticEorder(String tenantId, String appId, String companyId, String orderParamJson) {
        String result = "";
        JSONObject json = new JSONObject();
        json.put("code", (Object)-1);
        json.put("result", (Object)result);
        try {
            result = this.vaildateOrderParam(tenantId, appId, companyId, orderParamJson);
            if (!StringHelp.safeIsEmpty(result)) {
                json.put("message", (Object)result);
                return JSON.toJSONString((Object)json);
            }
            String url = this.systemPassSettings.getBaseUrl() + tenantUrl + tenantId + this.systemPassSettings.getLogisticsEorderUrl();
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("appId", appId);
            paramMap.put("companyId", companyId);
            paramMap.put("orderVO", orderParamJson);
            this.logger.debug("\u5728\u7ebf\u4e0b\u5355\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u5165\u53c2\uff1a{}", new Object[]{tenantId, url, JSON.toJSONString(paramMap)});
            String token = this.passTokenUtils.getLoginToken();
            HashMap<String, String> headerParam = new HashMap<String, String>();
            headerParam.put("x-app-token", token);
            result = HttpUtils.doJsonPost(url, JSON.toJSONString(paramMap));
            this.logger.debug("\u5728\u7ebf\u4e0b\u5355\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)tenantId, (Object)result);
        }
        catch (Exception e) {
            this.logger.error("\u5728\u7ebf\u4e0b\u5355\u5f02\u5e38\uff0c\u79df\u6237ID\uff1a{}\uff0c\u5f02\u5e38\u539f\u56e0\uff1a{}", (Object)tenantId, (Object)e.getMessage());
        }
        return result;
    }

    private String vaildateOrderParam(String tenantId, String appId, String companyId, String orderParamJson) {
        if (StringHelp.safeIsEmpty(tenantId)) {
            return "\u79df\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a.";
        }
        if (StringHelp.safeIsEmpty(appId)) {
            return "\u5e94\u7528id\u4e0d\u80fd\u4e3a\u7a7a.";
        }
        if (StringHelp.safeIsEmpty(companyId)) {
            return "\u516c\u53f8ID\u4e0d\u80fd\u4e3a\u7a7a.";
        }
        if (StringHelp.safeIsEmpty(orderParamJson)) {
            return "\u8ba2\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a.";
        }
        return "";
    }

    private String vaildateTrackParam(String tenantId, String appId, String expressCode, String parcelNo) {
        if (StringHelp.safeIsEmpty(tenantId)) {
            return "\u79df\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a.";
        }
        if (StringHelp.safeIsEmpty(appId)) {
            return "\u5e94\u7528id\u4e0d\u80fd\u4e3a\u7a7a.";
        }
        if (StringHelp.safeIsEmpty(expressCode)) {
            return "\u7269\u6d41\u516c\u53f8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a.";
        }
        if (StringHelp.safeIsEmpty(parcelNo)) {
            return "\u7269\u6d41\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a.";
        }
        return "";
    }
}

