/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.system.pass;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.help.HttpUtils;
import com.xforceplus.elephant.basecommon.system.pass.SystemPassSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;

@Component
public class PassTokenUtils {
    private Logger logger = LoggerFactory.getLogger(PassTokenUtils.class);
    @Autowired
    private SystemPassSettings systemPassSettings;

    @Cacheable(cacheNames={"passToken"}, unless="#result == null || #result == ''")
    public String getLoginToken() {
        String token = "";
        try {
            String tokenUrl = this.systemPassSettings.getBaseUrl() + this.systemPassSettings.getTokenUrl();
            JSONObject reqJson = new JSONObject();
            reqJson.put("clientId", (Object)this.systemPassSettings.getClientId());
            reqJson.put("secret", (Object)this.systemPassSettings.getSecret());
            this.logger.debug("pass\u767b\u5f55token\u4fe1\u606f\u8bf7\u6c42\u5730\u5740\uff1a{},\u8bf7\u6c42\u5165\u53c2\uff1a{}", (Object)tokenUrl, (Object)reqJson.toJSONString());
            String tokenJson = HttpUtils.doJsonPost(tokenUrl, reqJson.toJSONString());
            this.logger.debug("pass\u767b\u5f55token\u4fe1\u606f\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)tokenJson);
            JSONObject jsonObj = (JSONObject)JSON.parseObject((String)tokenJson, JSONObject.class);
            Integer code = (Integer)jsonObj.get((Object)"code");
            if (code == 1) {
                token = (String)jsonObj.get((Object)"data");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u83b7\u53d6pass\u767b\u5f55token\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
        return token;
    }
}

