/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.log;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.annotation.LogApi;
import com.xforceplus.elephant.basecommon.baseconst.MqConst;
import com.xforceplus.elephant.basecommon.enums.log.IsSuccessEnum;
import com.xforceplus.elephant.basecommon.help.BeanUtils;
import com.xforceplus.elephant.basecommon.help.JsonHelp;
import com.xforceplus.elephant.basecommon.log.LogApiWithBLOBs;
import com.xforceplus.elephant.basecommon.log.MyThreadLocal;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.UUID;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.support.CorrelationData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

@Aspect
@Component
public class LogAspect {
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Resource
    HttpServletRequest httpServletRequest;
    @Resource
    MyThreadLocal myThreadLocal;
    private static Logger logger = LoggerFactory.getLogger(BeanUtils.class);

    @Pointcut(value="@annotation(com.xforceplus.elephant.basecommon.annotation.LogApi)")
    public void logPoint() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="logPoint()")
    public void aroundMethod(JoinPoint joinPoint) throws ClassNotFoundException {
        StopWatch stopWatch = new StopWatch(joinPoint.getSignature().getName());
        LogApiWithBLOBs logApiEntity = new LogApiWithBLOBs();
        joinPoint.getSignature().getDeclaringType();
        String targetName = joinPoint.getTarget().getClass().getName();
        Class<?> targetClass = Class.forName(targetName);
        Method[] methods = targetClass.getMethods();
        String methodName = joinPoint.getSignature().getName();
        String methodDescription = "";
        String sender = "";
        String receiver = "";
        String params = "";
        String methodCode = "";
        int systemType = 0;
        if (joinPoint.getArgs() != null && joinPoint.getArgs().length > 0) {
            for (Object objects : joinPoint.getArgs()) {
                params = params + JsonHelp.toString(objects) + ";";
            }
        }
        for (Method method : methods) {
            if (!method.getName().equals(methodName)) continue;
            methodDescription = method.getAnnotation(LogApi.class).methodDescription();
            sender = method.getAnnotation(LogApi.class).sender();
            receiver = method.getAnnotation(LogApi.class).receiver();
            methodCode = method.getAnnotation(LogApi.class).methodCode();
            systemType = method.getAnnotation(LogApi.class).systemType();
            break;
        }
        logApiEntity.setCreateTime(new Date());
        logApiEntity.setCreateUser("\u7cfb\u7edf");
        logApiEntity.setMethodName(methodName);
        logApiEntity.setMethodDescription(methodDescription);
        logApiEntity.setParams(params);
        logApiEntity.setMethodUrl(this.httpServletRequest.getRequestURI());
        logApiEntity.setSender(sender);
        logApiEntity.setReceiver(receiver);
        logApiEntity.setMethodCode(methodCode);
        logApiEntity.setSystemType(systemType);
        try {
            stopWatch.start();
            Object object = ((ProceedingJoinPoint)joinPoint).proceed();
            stopWatch.stop();
            LogAspect logAspect = this;
            String number = (String)logAspect.myThreadLocal.getObject();
            LogAspect logAspect2 = this;
            logAspect2.myThreadLocal.removeObject();
            logApiEntity.setIssuccess(IsSuccessEnum.SUCCESS.getCode());
            logApiEntity.setNumber(number);
            logApiEntity.setResult(JsonHelp.toString(object));
            logApiEntity.setExecutionTime(JsonHelp.toString(stopWatch.getTotalTimeSeconds()));
        }
        catch (Throwable throwable) {
            logApiEntity.setIssuccess(IsSuccessEnum.FAIL.getCode());
            logApiEntity.setExceptionDetail(throwable.getMessage());
            logger.error("\u6267\u884c\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f:", (Object)throwable.getMessage());
        }
        finally {
            String message = JSONObject.toJSONString((Object)logApiEntity);
            this.rabbitTemplate.convertAndSend(MqConst.DIRECT_EXCHANGE, "logMq", (Object)message, new CorrelationData(UUID.randomUUID().toString()));
        }
    }
}

