/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.rabbitmq;

import com.alibaba.fastjson.JSON;
import java.util.Map;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RabbitmqUtils {
    @Autowired
    private RabbitTemplate rabbitTemplate;

    public void sendByDirectExchange(String routingKey, Object msg) {
        this.send("directExchange", routingKey, msg, null);
    }

    public void sendByDirectExchange(String routingKey, Object msg, Map<String, Object> headers) {
        this.send("directExchange", routingKey, msg, headers);
    }

    public void sendByTopicExchange(String routingKey, Object msg) {
        this.send("topicExchange", routingKey, msg, null);
    }

    public void sendByTopicExchange(String routingKey, Object msg, Map<String, Object> headers) {
        this.send("topicExchange", routingKey, msg, headers);
    }

    public void sendByFanoutExchange(Object msg) {
        this.send("fanoutExchange", null, msg, null);
    }

    public void sendByFanoutExchange(Object msg, Map<String, Object> headers) {
        this.send("fanoutExchange", null, msg, headers);
    }

    public void send(String exchange, String routingKey, Object msg, Map<String, Object> headers) {
        MessageProperties messageProperties = new MessageProperties();
        if (null != headers) {
            messageProperties.getHeaders().putAll(headers);
        }
        String jsonMsg = JSON.toJSONString((Object)msg);
        Message message = new Message(jsonMsg.getBytes(), messageProperties);
        this.rabbitTemplate.convertAndSend(exchange, routingKey, (Object)message);
    }

    public void send(String exchange, String routingKey, Object msg, Integer priority, String expires) {
        String jsonMsg = JSON.toJSONString((Object)msg);
        this.rabbitTemplate.convertAndSend(exchange, routingKey, (Object)jsonMsg, message -> {
            if (null != priority) {
                message.getMessageProperties().setPriority(priority);
            }
            if (null != expires) {
                message.getMessageProperties().setExpiration(expires);
            }
            return message;
        });
    }
}

