/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.help;

import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateHelp {
    private static final Logger logger = LoggerFactory.getLogger(DateHelp.class);
    private static final String TIME_FORMAT_NORMAL_MILLISECOND = "yyyy-MM-dd HH:mm:ss:SSS";
    private static final String TIME_FORMAT_NORMAL = "yyyy-MM-dd HH:mm:ss";
    private static final String TIME_FORMAT_NORMAL_ENGLISH = "yyyy-MM-dd HH:mm";
    private static final String TIME_FORMAT_ENGLISH = "MM/dd/yyyy HH:mm:ss";
    private static final String DATE_FORMAT_NORMAL = "yyyy-MM-dd";
    private static final String DATE_FORMAT_ENGLISH = "MM/dd/yyyy";
    private static final String YEAR_MONTH_FORMAT = "yyyy-MM";
    private static final String TIME_FORMAT_SHORT = "yyyyMMddHHmmss";
    private static final String DATE_FORMAT_MINUTE = "yyyyMMddHHmm";
    private static final String TIME_FORMAT_CHINA = "yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206dd\u79d2";
    private static final String DATE_FORMAT_CHINA = "yyyy\u5e74MM\u6708dd\u65e5";
    private static final String TIME_FORMAT_YMD = "yyyyMMdd";
    private static final String TIME_FORMAT_YM = "yyyyMM";
    private static final String TIME_FORMAT_SHORT_S = "HH:mm:ss";
    private static final Long DEFAULT_TIME = 14400000L;

    public static Date getNowDate() {
        return new Date();
    }

    public static String getDateNormalStr(Date date) {
        SimpleDateFormat fmt = new SimpleDateFormat(DATE_FORMAT_NORMAL);
        return fmt.format(date);
    }

    public static String getDateChinaStr(Date date) {
        SimpleDateFormat fmt = new SimpleDateFormat(DATE_FORMAT_CHINA);
        return fmt.format(date);
    }

    public static String getTimeNormalChinaStr(Date date) {
        SimpleDateFormat fmt = new SimpleDateFormat(TIME_FORMAT_CHINA);
        return fmt.format(date);
    }

    public static String getYearMonthStr(Date date) {
        SimpleDateFormat fmt = new SimpleDateFormat(YEAR_MONTH_FORMAT);
        return fmt.format(date);
    }

    public static String getTimeNormalStr(Date date) {
        SimpleDateFormat fmt = new SimpleDateFormat(TIME_FORMAT_NORMAL);
        return fmt.format(date);
    }

    public static String getTimeShortStr(Date date) {
        SimpleDateFormat fmt = new SimpleDateFormat(TIME_FORMAT_SHORT);
        return fmt.format(date);
    }

    public static String getTimeStrYMD(Date date) {
        SimpleDateFormat fmt = new SimpleDateFormat(TIME_FORMAT_YMD);
        return fmt.format(date);
    }

    public static String getTimeStrYM(Date date) {
        SimpleDateFormat fmt = new SimpleDateFormat(TIME_FORMAT_YM);
        return fmt.format(date);
    }

    public static Date convertStrToDate(String dateString, String dateFormat) {
        if (ValidatorUtil.isEmpty(dateString)) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        Date date = null;
        try {
            date = sdf.parse(dateString);
        }
        catch (Exception e) {
            return null;
        }
        return date;
    }

    public static Date convertStrToDate(String dateStr) {
        if (ValidatorUtil.isEmpty(dateStr)) {
            return null;
        }
        SimpleDateFormat fmt = null;
        if (dateStr.matches("\\d{14}")) {
            fmt = new SimpleDateFormat(TIME_FORMAT_SHORT);
        } else if (dateStr.matches("\\d{4}-\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}")) {
            fmt = new SimpleDateFormat(TIME_FORMAT_NORMAL);
        } else if (dateStr.matches("\\d{4}-\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}")) {
            fmt = new SimpleDateFormat(TIME_FORMAT_NORMAL_ENGLISH);
        } else if (dateStr.matches("\\d{4}-\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}:\\d{1,3}")) {
            fmt = new SimpleDateFormat(TIME_FORMAT_NORMAL_MILLISECOND);
        } else if (dateStr.matches("\\d{4}-\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}.\\d{1,3}")) {
            dateStr = dateStr.replace(".", ":");
            fmt = new SimpleDateFormat(TIME_FORMAT_NORMAL_MILLISECOND);
        } else if (dateStr.matches("\\d{1,2}/\\d{1,2}/\\d{4} \\d{1,2}:\\d{1,2}:\\d{1,2}")) {
            fmt = new SimpleDateFormat(TIME_FORMAT_ENGLISH);
        } else if (dateStr.matches("\\d{4}\u5e74\\d{1,2}\u6708\\d{1,2}\u65e5 \\d{1,2}\u65f6\\d{1,2}\u5206\\d{1,2}\u79d2")) {
            fmt = new SimpleDateFormat(TIME_FORMAT_CHINA);
        } else if (dateStr.matches("\\d{8}")) {
            fmt = new SimpleDateFormat(TIME_FORMAT_YMD);
        } else if (dateStr.matches("\\d{4}-\\d{1,2}-\\d{1,2}")) {
            fmt = new SimpleDateFormat(DATE_FORMAT_NORMAL);
        } else if (dateStr.matches("\\d{1,2}/\\d{1,2}/\\d{4}")) {
            fmt = new SimpleDateFormat(DATE_FORMAT_ENGLISH);
        } else if (dateStr.matches("\\d{4}\u5e74\\d{1,2}\u6708\\d{1,2}\u65e5")) {
            fmt = new SimpleDateFormat(DATE_FORMAT_CHINA);
        } else if (dateStr.matches("\\d{4}\\d{1,2}\\d{1,2}\\d{1,2}\\d{1,2}")) {
            fmt = new SimpleDateFormat(DATE_FORMAT_MINUTE);
        } else if (dateStr.matches("\\d{1,2}:\\d{1,2}:\\d{1,2}")) {
            fmt = new SimpleDateFormat(TIME_FORMAT_SHORT_S);
        } else {
            return null;
        }
        try {
            return fmt.parse(dateStr);
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("Date or Time String is invalid.");
        }
    }

    public static long getDayDiff_day(Date beginCalendar, Date endCalendar) {
        try {
            long l = beginCalendar.getTime() - endCalendar.getTime();
            long day = l / 86400000L;
            return day;
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    public static long getDayDiff_hour(Date beginCalendar, Date endCalendar) {
        try {
            long l = beginCalendar.getTime() - endCalendar.getTime();
            long day = l / 86400000L;
            long hour = l / 3600000L - day * 24L;
            return hour;
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    public static long getDayDiff_min(Date beginCalendar, Date endCalendar) {
        try {
            long l = beginCalendar.getTime() - endCalendar.getTime();
            long day = l / 86400000L;
            long hour = l / 3600000L - day * 24L;
            long min = l / 60000L - day * 24L * 60L - hour * 60L;
            return min;
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    public static long getDayDiff_sec(Date beginCalendar, Date endCalendar) {
        try {
            long l = beginCalendar.getTime() - endCalendar.getTime();
            long day = l / 86400000L;
            long hour = l / 3600000L - day * 24L;
            long min = l / 60000L - day * 24L * 60L - hour * 60L;
            long s = l / 1000L - day * 24L * 60L * 60L - hour * 60L * 60L - min * 60L;
            return s;
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    public static String getDayDiff_str(long startDate, long endDate) {
        String diffStr = "";
        try {
            long minute1;
            long hour1;
            if (startDate - DEFAULT_TIME == 0L) {
                return "";
            }
            if (endDate - DEFAULT_TIME == 0L) {
                return "";
            }
            long diff = endDate - startDate;
            long between = diff / 1000L;
            long day1 = between / 86400L;
            if (day1 > 0L) {
                diffStr = diffStr + day1 + "\u5929";
            }
            if ((hour1 = between % 86400L / 3600L) > 0L) {
                diffStr = diffStr + hour1 + "\u5c0f\u65f6";
            }
            if ((minute1 = between % 3600L / 60L) > 0L) {
                diffStr = diffStr + minute1 + "\u5206";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u8ba1\u7b97\u65f6\u95f4\u5dee\u51fa\u73b0\u5f02\u5e38");
        }
        return diffStr;
    }

    public static void main(String[] args) {
        System.out.println(DateHelp.getTimeNormalChinaStr(DateHelp.getNowDate()));
        System.out.println(DateHelp.convertStrToDate("2019-12-31 01:21"));
        long star = 1567501240000L;
        long end = System.currentTimeMillis();
        String s = DateHelp.getDayDiff_str(star, end);
        System.out.println(s);
    }
}

