/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.rabbitmq;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.GetResponse;
import com.xforceplus.elephant.basecommon.exception.ElephantException;
import com.xforceplus.elephant.basecommon.rabbitmq.entity.MqMessageEntity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RabbitmqUtils {
    @Autowired
    private RabbitTemplate rabbitTemplate;

    public void sendByDirectExchange(String routingKey, Object msg) {
        this.send("directExchange", routingKey, msg, null);
    }

    public void sendByDirectExchange(String routingKey, Object msg, Map<String, Object> headers) {
        this.send("directExchange", routingKey, msg, headers);
    }

    public void sendByTopicExchange(String routingKey, Object msg) {
        this.send("topicExchange", routingKey, msg, null);
    }

    public void sendByTopicExchange(String routingKey, Object msg, Map<String, Object> headers) {
        this.send("topicExchange", routingKey, msg, headers);
    }

    public void sendByFanoutExchange(Object msg) {
        this.send("fanoutExchange", null, msg, null);
    }

    public void sendByFanoutExchange(Object msg, Map<String, Object> headers) {
        this.send("fanoutExchange", null, msg, headers);
    }

    public void send(String exchange, String routingKey, Object msg, Map<String, Object> headers) {
        MessageProperties messageProperties = new MessageProperties();
        if (null != headers) {
            messageProperties.getHeaders().putAll(headers);
        }
        String jsonMsg = JSON.toJSONString((Object)msg);
        Message message = new Message(jsonMsg.getBytes(), messageProperties);
        this.rabbitTemplate.convertAndSend(exchange, routingKey, (Object)message);
    }

    public void send(String exchange, String routingKey, Object msg, Integer priority, String expires) {
        String jsonMsg = JSON.toJSONString((Object)msg);
        this.rabbitTemplate.convertAndSend(exchange, routingKey, (Object)jsonMsg, message -> {
            if (null != priority) {
                message.getMessageProperties().setPriority(priority);
            }
            if (null != expires) {
                message.getMessageProperties().setExpiration(expires);
            }
            return message;
        });
    }

    public List<MqMessageEntity> getMessageList(Integer num, String queueName) {
        ArrayList resultList = Lists.newArrayList();
        Connection connection = null;
        Channel channel = null;
        try {
            ConnectionFactory connectionFactory = this.rabbitTemplate.getConnectionFactory();
            connection = connectionFactory.createConnection();
            channel = connection.createChannel(false);
            while (num > 0) {
                MqMessageEntity entity = new MqMessageEntity();
                GetResponse response = channel.basicGet(queueName, false);
                if (null == response) continue;
                entity.setMessage(new String(response.getBody()));
                entity.setDeliveryTag(response.getEnvelope().getDeliveryTag());
                if (response.getProps() != null && response.getProps().getHeaders() != null) {
                    Map properties = response.getProps().getHeaders();
                    properties.entrySet().stream().forEach(r -> r.setValue(new String(r.getValue().toString())));
                    entity.setProperties(JSONObject.toJSONString((Object)properties));
                    if (response.getProps().getHeaders().get("x-first-death-exchange") != null) {
                        entity.setExchange(new String(response.getProps().getHeaders().get("x-first-death-exchange").toString()));
                    }
                    if (response.getProps().getHeaders().get("x-first-death-queue") != null) {
                        entity.setQueueName(new String(response.getProps().getHeaders().get("x-first-death-queue").toString()));
                    }
                    if (response.getProps().getHeaders().get("x-death") != null) {
                        List jsonArray = (List)response.getProps().getHeaders().get("x-death");
                        entity.setCreateTime(new Date(((Map)jsonArray.get(0)).get("time").toString()).getTime());
                    }
                }
                resultList.add(entity);
                if (response.getMessageCount() == 0) {
                    num = 0;
                    continue;
                }
                Integer n = num;
                Integer n2 = num = Integer.valueOf(num - 1);
            }
        }
        catch (Exception e) {
            throw new ElephantException("\u83b7\u53d6MQ\u6d88\u606f\u5f02\u5e38\uff1a" + e.getMessage());
        }
        finally {
            try {
                if (null != channel) {
                    channel.close();
                }
                if (null != connection) {
                    connection.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (TimeoutException e) {
                e.printStackTrace();
            }
        }
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MqMessageEntity> getMessageList1(Integer num, String queueName) {
        final ArrayList resultList = Lists.newArrayList();
        try {
            ConnectionFactory connectionFactory = this.rabbitTemplate.getConnectionFactory();
            Connection connection = connectionFactory.createConnection();
            final Channel channel = connection.createChannel(false);
            channel.basicQos(num.intValue());
            channel.basicConsume(queueName, false, (Consumer)new DefaultConsumer(channel){

                public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties1, byte[] body) throws IOException {
                    MqMessageEntity entity = new MqMessageEntity();
                    entity.setMessage(new String(body));
                    entity.setDeliveryTag(envelope.getDeliveryTag());
                    if (properties1 != null) {
                        Map properties = properties1.getHeaders();
                        properties.entrySet().stream().forEach(r -> r.setValue(new String(r.getValue().toString())));
                        entity.setProperties(JSONObject.toJSONString((Object)properties));
                        if (properties.get("x-first-death-exchange") != null) {
                            entity.setExchange(new String(properties.get("x-first-death-exchange").toString()));
                        }
                        if (properties.get("x-first-death-queue") != null) {
                            entity.setQueueName(new String(properties.get("x-first-death-queue").toString()));
                        }
                        if (properties.get("x-death") != null) {
                            List jsonArray = (List)properties.get("x-death");
                            entity.setCreateTime(new Date(((Map)jsonArray.get(0)).get("time").toString()).getTime());
                        }
                    }
                    resultList.add(entity);
                    channel.basicReject(envelope.getDeliveryTag(), false);
                }
            });
            channel.close();
            connection.close();
        }
        catch (Exception exception) {}
        return resultList;
    }
}

