/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.rabbitmq;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import com.xforceplus.elephant.basecommon.exception.ElephantException;
import com.xforceplus.elephant.basecommon.rabbitmq.entity.MqMessageEntity;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RabbitmqUtils {
    @Autowired
    private RabbitTemplate rabbitTemplate;

    public void sendByDirectExchange(String routingKey, Object msg) {
        this.send("directExchange", routingKey, msg, null);
    }

    public void sendByDirectExchange(String routingKey, Object msg, Map<String, Object> headers) {
        this.send("directExchange", routingKey, msg, headers);
    }

    public void sendByTopicExchange(String routingKey, Object msg) {
        this.send("topicExchange", routingKey, msg, null);
    }

    public void sendByTopicExchange(String routingKey, Object msg, Map<String, Object> headers) {
        this.send("topicExchange", routingKey, msg, headers);
    }

    public void sendByFanoutExchange(Object msg) {
        this.send("fanoutExchange", null, msg, null);
    }

    public void sendByFanoutExchange(Object msg, Map<String, Object> headers) {
        this.send("fanoutExchange", null, msg, headers);
    }

    public void send(String exchange, String routingKey, Object msg, Map<String, Object> headers) {
        MessageProperties messageProperties = new MessageProperties();
        if (null != headers) {
            messageProperties.getHeaders().putAll(headers);
        }
        String jsonMsg = JSON.toJSONString((Object)msg);
        Message message = new Message(jsonMsg.getBytes(), messageProperties);
        this.rabbitTemplate.convertAndSend(exchange, routingKey, (Object)message);
    }

    public void send(String exchange, String routingKey, Object msg, Integer priority, String expires) {
        String jsonMsg = JSON.toJSONString((Object)msg);
        this.rabbitTemplate.convertAndSend(exchange, routingKey, (Object)jsonMsg, message -> {
            if (null != priority) {
                message.getMessageProperties().setPriority(priority);
            }
            if (null != expires) {
                message.getMessageProperties().setExpiration(expires);
            }
            return message;
        });
    }

    public List<MqMessageEntity> getMessageList(Integer num, String queueName) {
        final ArrayList resultList = Lists.newArrayList();
        Connection connection = null;
        Channel channel = null;
        try {
            ConnectionFactory connectionFactory = this.rabbitTemplate.getConnectionFactory();
            connection = connectionFactory.createConnection();
            channel = connection.createChannel(false);
            Integer count = this.getMessageCount(channel, queueName);
            if (count < num) {
                num = count;
            }
            channel.basicQos(num.intValue());
            final Channel finalChannel = channel;
            String consumeTag = channel.basicConsume(queueName, false, (Consumer)new DefaultConsumer(finalChannel){

                public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
                    MqMessageEntity entity = new MqMessageEntity();
                    entity.setMessage(new String(body));
                    entity.setDeliveryTag(envelope.getDeliveryTag());
                    if (null != properties && null != properties.getHeaders()) {
                        Map props = properties.getHeaders();
                        HashMap tempProp = Maps.newHashMap();
                        props.entrySet().stream().forEach(r -> {
                            if (((String)r.getKey()).equals("x-first-death-exchange") && r.getValue() != null) {
                                entity.setExchange(new String(r.getValue().toString()));
                            } else if (((String)r.getKey()).equals("x-first-death-queue") && r.getValue() != null) {
                                entity.setQueueName(new String(r.getValue().toString()));
                            } else if (((String)r.getKey()).equals("x-death") && r.getValue() != null) {
                                String str = r.getValue().toString();
                                if (!ValidatorUtil.isEmpty(str = str.substring(str.indexOf("time=") + 5, str.indexOf("routing-keys") - 2))) {
                                    entity.setCreateTime(new Date(str).getTime());
                                }
                            } else if (!((String)r.getKey()).equals("x-first-death-reason")) {
                                tempProp.put(r.getKey(), new String(r.getValue().toString()));
                            }
                        });
                        if (null != tempProp && tempProp.size() > 0) {
                            entity.setProperties(JSONObject.toJSONString((Object)tempProp));
                        }
                    }
                    resultList.add(entity);
                    finalChannel.basicReject(envelope.getDeliveryTag(), true);
                }
            });
            channel.basicCancel(consumeTag);
        }
        catch (Exception e) {
            throw new ElephantException("\u83b7\u53d6MQ\u6d88\u606f\u5f02\u5e38\uff1a" + e.getMessage());
        }
        finally {
            try {
                if (null != channel) {
                    channel.close();
                }
                if (null != connection) {
                    connection.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (TimeoutException e) {
                e.printStackTrace();
            }
        }
        return resultList;
    }

    public void handleMessage(final Long deliveryTag, String queueName, final String exchange, final String sourceQueueName, final String message, final Map<String, Object> heareds, final boolean isHandle) {
        Connection connection = null;
        Channel channel = null;
        try {
            ConnectionFactory connectionFactory = this.rabbitTemplate.getConnectionFactory();
            connection = connectionFactory.createConnection();
            channel = connection.createChannel(false);
            channel.basicQos(deliveryTag.intValue());
            final Channel finalChannel = channel;
            String consumeTag = channel.basicConsume(queueName, false, (Consumer)new DefaultConsumer(finalChannel){

                public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
                    if (envelope.getDeliveryTag() == deliveryTag.longValue()) {
                        if (isHandle) {
                            RabbitmqUtils.this.send(exchange, sourceQueueName, message, heareds);
                        }
                        finalChannel.basicAck(deliveryTag.longValue(), false);
                    } else {
                        finalChannel.basicReject(envelope.getDeliveryTag(), true);
                    }
                }
            });
            channel.basicCancel(consumeTag);
        }
        catch (Exception e) {
            throw new ElephantException("\u624b\u52a8\u5904\u7406MQ\u6d88\u606f\u5f02\u5e38\uff1a" + e.getMessage());
        }
        finally {
            try {
                if (null != channel) {
                    channel.close();
                }
                if (null != connection) {
                    connection.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (TimeoutException e) {
                e.printStackTrace();
            }
        }
    }

    public Integer getMessageCount(Channel channel, String queueName) {
        Integer count = 0;
        Connection connection = null;
        try {
            if (null == channel) {
                ConnectionFactory connectionFactory = this.rabbitTemplate.getConnectionFactory();
                connection = connectionFactory.createConnection();
                channel = connection.createChannel(false);
            }
            AMQP.Queue.DeclareOk declareOk = channel.queueDeclarePassive(queueName);
            count = declareOk.getMessageCount();
        }
        catch (Exception e) {
            throw new ElephantException("\u83b7\u53d6MQ\u6d88\u606f\u603b\u6570\u5f02\u5e38\uff1a" + e.getMessage());
        }
        finally {
            try {
                if (null != channel) {
                    channel.close();
                }
                if (null != connection) {
                    connection.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (TimeoutException e) {
                e.printStackTrace();
            }
        }
        return count;
    }
}

