/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.help;

import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class HttpUtils {
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String APPLICATION_JSON = "application/json";
    private static final String DEFAULT_CHARSET = "UTF-8";
    static final Logger logger = LoggerFactory.getLogger(HttpUtils.class);
    private static CloseableHttpClient httpClient;

    @Value(value="${httpTimeOut:10}")
    public static void createClient(int timeout) {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(timeout * 1000).setConnectionRequestTimeout(timeout * 1000).setSocketTimeout(timeout * 1000).build();
        try {
            TrustStrategy acceptingTrustStrategy = (cert, authType) -> true;
            SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)acceptingTrustStrategy).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)sslsf).register("http", (Object)new PlainConnectionSocketFactory()).build();
            BasicHttpClientConnectionManager connectionManager = new BasicHttpClientConnectionManager((Lookup)socketFactoryRegistry);
            httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)connectionManager).build();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String doGet(String url, Map<String, String> headers, Map<String, String> params) throws Exception {
        try (CloseableHttpResponse response = HttpUtils.request(url, "GET", headers, params, null, null);){
            String string = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.defaultCharset());
            return string;
        }
        catch (IOException e) {
            logger.error("\u8bf7\u6c42\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String doGet(String url, Map<String, String> params) throws Exception {
        try (CloseableHttpResponse response = HttpUtils.request(url, "GET", null, params, null, null);){
            String string = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.defaultCharset());
            return string;
        }
        catch (IOException e) {
            logger.error("\u8bf7\u6c42\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String doJsonPost(String url, String json) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(CONTENT_TYPE, APPLICATION_JSON);
        try (CloseableHttpResponse response = HttpUtils.request(url, "POST", headers, null, json, null);){
            String string = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.defaultCharset());
            return string;
        }
        catch (IOException e) {
            logger.error("\u8bf7\u6c42\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String doJsonPost(String url, Map<String, String> headers, String json) throws Exception {
        headers.put(CONTENT_TYPE, APPLICATION_JSON);
        try (CloseableHttpResponse response = HttpUtils.request(url, "POST", headers, null, json, null);){
            String string = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.defaultCharset());
            return string;
        }
        catch (IOException e) {
            logger.error("\u8bf7\u6c42\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String doPost(String url, Map<String, String> headers, Map<String, String> params) throws Exception {
        try (CloseableHttpResponse response = HttpUtils.request(url, "POST", headers, params, null, null);){
            String string = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.defaultCharset());
            return string;
        }
        catch (IOException e) {
            logger.error("\u8bf7\u6c42\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String doPost(String url, Map<String, String> headers, Map<String, String> params, String body) throws Exception {
        try (CloseableHttpResponse response = HttpUtils.request(url, "POST", headers, params, body, null);){
            String string = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.defaultCharset());
            return string;
        }
        catch (IOException e) {
            logger.error("\u8bf7\u6c42\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String doPut(String url, Map<String, String> headers, Map<String, String> params, String body) throws Exception {
        try (CloseableHttpResponse response = HttpUtils.request(url, "PUT", headers, params, body, null);){
            String string = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.defaultCharset());
            return string;
        }
        catch (IOException e) {
            logger.error("\u8bf7\u6c42\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String doDelete(String url, Map<String, String> headers, Map<String, String> params) throws Exception {
        try (CloseableHttpResponse response = HttpUtils.request(url, "DELETE", headers, params, null, null);){
            String string = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.defaultCharset());
            return string;
        }
        catch (IOException e) {
            logger.error("\u8bf7\u6c42\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String doGet(String url) {
        try (CloseableHttpResponse response = HttpUtils.request(url, "GET", null, null, null, null);){
            String string = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.defaultCharset());
            return string;
        }
        catch (IOException e) {
            logger.error("\u8bf7\u6c42\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static InputStream doGetInputStream(String url) {
        try (CloseableHttpResponse response = HttpUtils.request(url, "GET", null, null, null, null);){
            byte[] bytes = EntityUtils.toByteArray((HttpEntity)response.getEntity());
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
            return byteArrayInputStream;
        }
        catch (IOException e) {
            logger.error("\u8bf7\u6c42\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    private static CloseableHttpResponse request(String url, String method, Map<String, String> headers, Map<String, String> params, String body, String charset) throws IOException {
        Charset cs = Charset.defaultCharset();
        if (ValidatorUtil.isNotEmpty(charset)) {
            cs = Charset.forName(charset);
        }
        RequestBuilder rb = RequestBuilder.create((String)method).setUri(url).setCharset(cs);
        if (ValidatorUtil.isNotEmpty(headers)) {
            headers.entrySet().forEach(entry -> rb.addHeader((String)entry.getKey(), (String)entry.getValue()));
        }
        if (ValidatorUtil.isNotEmpty(params)) {
            params.entrySet().forEach(entry -> rb.addParameter((String)entry.getKey(), (String)entry.getValue()));
        }
        if (ValidatorUtil.isNotEmpty(body)) {
            rb.setEntity((HttpEntity)new StringEntity(body, cs));
        }
        HttpUriRequest httpRequest = rb.build();
        return httpClient.execute(httpRequest);
    }

    static {
        HttpUtils.createClient(10);
    }
}

