/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.system.paas;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.exception.ElephantException;
import com.xforceplus.elephant.basecommon.help.HttpUtils;
import com.xforceplus.elephant.basecommon.log.MyThreadLocal;
import com.xforceplus.elephant.basecommon.system.paas.PaasTokenUtils;
import com.xforceplus.elephant.basecommon.system.paas.SystemPaasSettings;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ImageCloudUtils {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SystemPaasSettings systemPaasSettings;
    @Autowired
    private PaasTokenUtils paasTokenUtils;

    public String invoiceGeneralPro(String tenantId, Long id, String imageUrl, String suffix) {
        try {
            MyThreadLocal.setObject(tenantId);
            String token = this.paasTokenUtils.getLoginToken();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            headers.put("x-app-token", token);
            JSONObject body = new JSONObject();
            body.put("title", (Object)("\u5f71\u50cf\u8bc6\u522b\u4efb\u52a1" + id));
            body.put("group", (Object)tenantId);
            body.put("scene", (Object)"4");
            body.put("file", (Object)imageUrl);
            body.put("fileSuffix", (Object)suffix);
            body.put("reserved", (Object)String.valueOf(id));
            String url = this.systemPaasSettings.getImageRegionUrl().replace("{tenant-id}", tenantId);
            String responseStr = HttpUtils.doPost(url, headers, null, body.toJSONString());
            JSONObject responseObj = JSON.parseObject((String)responseStr);
            if (ValidatorUtil.isEmpty((Map)responseObj)) {
                this.logger.warn("\u53d1\u8d77\u8bc6\u522b\u8bf7\u6c42\u5f02\u5e38");
                return null;
            }
            String code = responseObj.getString("code");
            if (responseObj.containsKey((Object)"result")) {
                return responseObj.getJSONObject("result").toJSONString();
            }
            this.logger.warn(responseObj.getString("message"));
            return null;
        }
        catch (Exception e) {
            this.logger.error("\u53d1\u8d77\u5f71\u50cf\u8bc6\u522b\u5931\u8d25", (Throwable)e);
            throw new ElephantException("\u53d1\u8d77\u5f71\u50cf\u8bc6\u522b\u5931\u8d25", e);
        }
    }

    public String getBatchTaskId(String tenantId, String[] taskIds) {
        try {
            MyThreadLocal.setObject(tenantId);
            String token = this.paasTokenUtils.getLoginToken();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            headers.put("x-app-token", token);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("batch", Arrays.toString(Arrays.stream(taskIds).map(taskId -> "\"" + taskId + "\"").toArray(String[]::new)));
            String url = this.systemPaasSettings.getImageResultUrl().replace("{tenant-id}", tenantId);
            String responseStr = HttpUtils.doGet(url, headers, params);
            JSONObject responseObj = JSON.parseObject((String)responseStr);
            if (ValidatorUtil.isEmpty((Map)responseObj)) {
                this.logger.warn("\u83b7\u53d6\u8bc6\u522b\u7ed3\u679c\u8bf7\u6c42\u5f02\u5e38");
                return null;
            }
            String code = responseObj.getString("code");
            if (responseObj.containsKey((Object)"result")) {
                return responseObj.getJSONArray("result").toJSONString();
            }
            this.logger.warn(responseObj.getString("message"));
            return null;
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u5f71\u50cf\u8bc6\u522b\u7ed3\u679c\u5931\u8d25", (Throwable)e);
            throw new ElephantException("\u83b7\u53d6\u5f71\u50cf\u8bc6\u522b\u7ed3\u679c\u5931\u8d25", e);
        }
    }
}

