/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.file.oss;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.DeleteObjectsRequest;
import com.aliyun.oss.model.DeleteObjectsResult;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectResult;
import com.xforceplus.elephant.basecommon.file.FileStorage;
import com.xforceplus.elephant.basecommon.file.oss.OSSSettings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OSSUtils
implements FileStorage {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private OSSClient client = null;
    private OSSSettings ossSettings;

    @Autowired
    public void setOssSettings(OSSSettings ossSettings) {
        if (ossSettings == null || ossSettings.getAccessId() == null || ossSettings.getAccessKey() == null || ossSettings.getOssEndpoint() == null || ossSettings.getBucketName() == null) {
            return;
        }
        if (this.ossSettings != null) {
            return;
        }
        this.ossSettings = ossSettings;
        String accessId = ossSettings.getAccessId();
        String accessKey = ossSettings.getAccessKey();
        String ossEndpoint = ossSettings.getOssEndpoint();
        this.client = new OSSClient(ossEndpoint, accessId, accessKey);
    }

    @Override
    public InputStream getFileInputStream(String key) {
        GetObjectRequest getObjectRequest = new GetObjectRequest(this.ossSettings.getBucketName(), key);
        OSSObject ossObject = this.client.getObject(getObjectRequest);
        InputStream in = ossObject.getObjectContent();
        return in;
    }

    public void putObject(String key, String filePath) throws IOException {
        File file = new File(filePath);
        try (FileInputStream content = new FileInputStream(file);){
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentLength(file.length());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("folderName", "20160307");
            meta.setUserMetadata(map);
            PutObjectResult result = this.client.putObject(this.ossSettings.getBucketName(), key, (InputStream)content, meta);
            System.out.println(result.getETag());
        }
    }

    public String putTempObjectByInputStream(String key, InputStream content) throws FileNotFoundException {
        String dayName = new SimpleDateFormat("yyyy/MM/dd").format(new Date());
        String pathKey = String.format("tmp/%s/%s", dayName, key);
        this.uploadFileByInputStream(pathKey, content);
        return pathKey;
    }

    @Override
    public void uploadFileByInputStream(String key, InputStream content) {
        this.logger.info("\u6587\u4ef6\u6d41\u4e0a\u4f20\u6587\u4ef6\u5f00\u59cb-----\uff01");
        ObjectMetadata meta = new ObjectMetadata();
        PutObjectResult result = this.client.putObject(this.ossSettings.getBucketName(), key, content, meta);
        this.logger.info("\u4e0a\u4f20\u8fd4\u56deobject\u5bf9\u8c61====\uff01", (Object)result.getETag());
        System.out.println(result.getETag());
    }

    public void downLoadToLocalPath(String key, String localKey) {
        GetObjectRequest getObjectRequest = new GetObjectRequest(this.ossSettings.getBucketName(), key);
        ObjectMetadata objectMetadata = this.client.getObject(getObjectRequest, new File(localKey));
    }

    @Override
    public boolean deleteFiles(String ... keys) {
        DeleteObjectsRequest deleteObjectsRequest = new DeleteObjectsRequest(this.ossSettings.getBucketName());
        deleteObjectsRequest.setKeys(Arrays.asList(keys));
        DeleteObjectsResult result = this.client.deleteObjects(deleteObjectsRequest);
        this.logger.info("\u5220\u9664{}\u6761\u6570\u636e", (Object)result.getDeletedObjects().size());
        return result.getDeletedObjects().size() == keys.length;
    }
}

