/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.file;

import com.xforceplus.elephant.basecommon.enums.common.UploadTypeEnum;
import com.xforceplus.elephant.basecommon.file.FileStorage;
import com.xforceplus.elephant.basecommon.file.ftp.FTPUtils;
import com.xforceplus.elephant.basecommon.file.minio.MinioUtils;
import com.xforceplus.elephant.basecommon.file.oss.OSSUtils;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class FileManager {
    private static final String UPLOAD_FILE_PATH = "elephant/%s/%s";
    @Value(value="${filestorage.updateType:}")
    private String updateType;
    @Autowired
    private OSSUtils ossUtils;
    @Autowired
    private FTPUtils ftpUtils;
    @Autowired
    private MinioUtils minioUtils;

    private FileStorage getFileStorage() {
        switch (UploadTypeEnum.valueOf(this.updateType)) {
            case FTP: {
                return this.ftpUtils;
            }
            case OSS: {
                return this.ossUtils;
            }
            case MINIO: {
                return this.minioUtils;
            }
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u4e0a\u4f20\u65b9\u5f0f");
    }

    public String uploadFile(String fileName, InputStream stream) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        String fileKey = String.format(UPLOAD_FILE_PATH, sdf.format(new Date()), fileName);
        return this.uploadFileByFileKey(fileKey, stream);
    }

    public String uploadFileByFileKey(String fileKey, InputStream stream) {
        FileStorage fileStorage = this.getFileStorage();
        fileStorage.uploadFileByInputStream(fileKey, stream);
        if (fileStorage.getFileInputStream(fileKey) != null) {
            return fileKey;
        }
        return null;
    }

    public InputStream getFile(String fileKey) {
        FileStorage fileStorage = this.getFileStorage();
        return fileStorage.getFileInputStream(fileKey);
    }

    public boolean deleteFile(String ... fileKeys) {
        FileStorage fileStorage = this.getFileStorage();
        return fileStorage.deleteFiles(fileKeys);
    }
}

