/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.system.paas;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.annotation.LogApi;
import com.xforceplus.elephant.basecommon.exception.ElephantException;
import com.xforceplus.elephant.basecommon.help.HttpUtils;
import com.xforceplus.elephant.basecommon.log.MyThreadLocal;
import com.xforceplus.elephant.basecommon.system.paas.DiscernUrlSettings;
import com.xforceplus.elephant.basecommon.system.paas.PaasTokenUtils;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ImageCloudUtils {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private DiscernUrlSettings discernUrlSettings;
    @Autowired
    private PaasTokenUtils paasTokenUtils;

    @LogApi(methodCode="sendOCR", methodDescription="\u53d1\u8d77\u8bc6\u522b", systemType=1, isRetry=0, sender="elephant", receiver="melete")
    public String invoiceGeneralPro(Integer imageCategory, Long tenantId, Long id, String imageUrl, String suffix) {
        try {
            String responseStr;
            JSONObject responseObj;
            MyThreadLocal.setObject(tenantId);
            String token = this.paasTokenUtils.getLoginToken();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            headers.put("x-app-token", token);
            JSONObject body = new JSONObject();
            body.put("title", (Object)("\u5f71\u50cf\u8bc6\u522b\u4efb\u52a1" + id));
            body.put("group", (Object)String.valueOf(tenantId));
            body.put("scene", (Object)"4");
            body.put("file", (Object)imageUrl);
            body.put("fileSuffix", (Object)suffix);
            body.put("reserved", (Object)String.valueOf(id));
            body.put("classifierId", (Object)String.valueOf(tenantId));
            String url = this.discernUrlSettings.getSendUrls().get(imageCategory);
            if (ValidatorUtil.isEmpty(url)) {
                url = this.discernUrlSettings.getSendUrls().get(0);
            }
            if (ValidatorUtil.isEmpty((Map)(responseObj = JSON.parseObject((String)(responseStr = HttpUtils.doPost(url = url.replace("{tenant-id}", String.valueOf(tenantId)), headers, null, body.toJSONString())))))) {
                this.logger.warn("\u53d1\u8d77\u8bc6\u522b\u8bf7\u6c42\u5f02\u5e38");
                return null;
            }
            String code = responseObj.getString("code");
            if (responseObj.containsKey((Object)"result")) {
                return responseObj.getJSONObject("result").toJSONString();
            }
            this.logger.warn(responseObj.getString("message"));
            return null;
        }
        catch (Exception e) {
            this.logger.error("\u53d1\u8d77\u5f71\u50cf\u8bc6\u522b\u5931\u8d25", (Throwable)e);
            throw new ElephantException("\u53d1\u8d77\u5f71\u50cf\u8bc6\u522b\u5931\u8d25", e);
        }
    }

    @LogApi(methodCode="getOCR", methodDescription="\u83b7\u53d6\u8bc6\u522b\u7ed3\u679c", systemType=1, isRetry=0, sender="elephant", receiver="melete")
    public String getBatchTaskId(Long tenantId, String[] taskIds) {
        try {
            MyThreadLocal.setObject(tenantId);
            String token = this.paasTokenUtils.getLoginToken();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            headers.put("x-app-token", token);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("batch", Arrays.toString(Arrays.stream(taskIds).map(taskId -> "\"" + taskId + "\"").toArray(String[]::new)));
            String url = this.discernUrlSettings.getGetUrl().replace("{tenant-id}", String.valueOf(tenantId));
            String responseStr = HttpUtils.doGet(url, headers, params);
            JSONObject responseObj = JSON.parseObject((String)responseStr);
            if (ValidatorUtil.isEmpty((Map)responseObj)) {
                this.logger.warn("\u83b7\u53d6\u8bc6\u522b\u7ed3\u679c\u8bf7\u6c42\u5f02\u5e38");
                return null;
            }
            String code = responseObj.getString("code");
            if (responseObj.containsKey((Object)"result")) {
                return responseObj.getJSONArray("result").toJSONString();
            }
            this.logger.warn(responseObj.getString("message"));
            return null;
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u5f71\u50cf\u8bc6\u522b\u7ed3\u679c\u5931\u8d25", (Throwable)e);
            throw new ElephantException("\u83b7\u53d6\u5f71\u50cf\u8bc6\u522b\u7ed3\u679c\u5931\u8d25", e);
        }
    }
}

