/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.system.paas;

import com.xforceplus.elephant.basecommon.annotation.LogApi;
import com.xforceplus.elephant.basecommon.enums.log.ReceiverEnum;
import com.xforceplus.elephant.basecommon.enums.log.SenderEnum;
import com.xforceplus.elephant.basecommon.enums.log.SystemTypeEnum;
import com.xforceplus.elephant.basecommon.exception.ElephantException;
import com.xforceplus.elephant.basecommon.help.HttpUtils;
import com.xforceplus.elephant.basecommon.log.MyThreadLocal;
import com.xforceplus.elephant.basecommon.system.paas.PaasTokenUtils;
import com.xforceplus.elephant.basecommon.system.paas.SystemPaasSettings;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserUtils {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SystemPaasSettings systemPaasSettings;
    @Autowired
    private PaasTokenUtils paasTokenUtils;

    @LogApi(methodCode="getUserInfoRequest", methodDescription="\u83b7\u53d6\u7528\u6237\u4fe1\u606f", systemType=SystemTypeEnum.IMAGE, isRetry=0, sender=SenderEnum.IMAGE, receiver=ReceiverEnum.PHOENIX)
    public String getUserInfoRequest(Long tenantId, Long userId) {
        try {
            String userIdStr = String.valueOf(userId);
            MyThreadLocal.setObject(tenantId, userIdStr, "", "");
            String url = this.systemPaasSettings.getUserInfoUrl().replace("{tenantId}", String.valueOf(tenantId)).replace("{userId}", userIdStr);
            String token = this.paasTokenUtils.getLoginToken();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            headers.put("x-app-token", token);
            this.logger.debug("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)tenantId, (Object)url);
            String responseStr = HttpUtils.doGet(url, headers, null);
            this.logger.debug("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)tenantId, (Object)responseStr);
            return responseStr;
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new ElephantException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5f02\u5e38", e);
        }
    }
}

