/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.system.paas;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.xforceplus.elephant.basecommon.annotation.LogApi;
import com.xforceplus.elephant.basecommon.enums.log.ReceiverEnum;
import com.xforceplus.elephant.basecommon.enums.log.SenderEnum;
import com.xforceplus.elephant.basecommon.enums.log.SystemTypeEnum;
import com.xforceplus.elephant.basecommon.exception.ElephantException;
import com.xforceplus.elephant.basecommon.help.HttpUtils;
import com.xforceplus.elephant.basecommon.log.MyThreadLocal;
import com.xforceplus.elephant.basecommon.system.paas.PaasTokenUtils;
import com.xforceplus.elephant.basecommon.system.paas.SystemPaasSettings;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VerifyUtils {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SystemPaasSettings systemPaasSettings;
    @Autowired
    private PaasTokenUtils paasTokenUtils;

    @LogApi(methodCode="sendVerifyRequest", methodDescription="\u53d1\u8d77\u9a8c\u771f", systemType=SystemTypeEnum.IMAGE, isRetry=0, sender=SenderEnum.IMAGE, receiver=ReceiverEnum.PHOENIX)
    public String sendVerifyRequest(Long tenantId, String invoiceCode, String invoiceNo, String paperDrewDate, String amount, String checkCode) {
        try {
            MyThreadLocal.setObject(tenantId, invoiceNo, invoiceNo, invoiceCode);
            String url = this.systemPaasSettings.getVerifyRequestUrl().replace("{tenant-id}", String.valueOf(tenantId));
            String token = this.paasTokenUtils.getLoginToken();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            headers.put("x-app-token", token);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("invoiceCode", invoiceCode);
            params.put("invoiceNo", invoiceNo);
            params.put("paperDrewDate", paperDrewDate);
            params.put("amount", amount);
            params.put("checkCode", checkCode);
            params.put("tenantCode", String.valueOf(tenantId));
            this.logger.debug("\u53d1\u8d77\u9a8c\u771f\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u5165\u53c2\uff1a{}", new Object[]{tenantId, url, JSON.toJSONString(params)});
            String responseStr = HttpUtils.doJsonPost(url, headers, JSON.toJSONString(params));
            this.logger.debug("\u53d1\u8d77\u9a8c\u771f\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)tenantId, (Object)responseStr);
            return responseStr;
        }
        catch (Exception e) {
            this.logger.error("\u53d1\u8d77\u9a8c\u771f\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new ElephantException("\u53d1\u8d77\u9a8c\u771f\u5f02\u5e38", e);
        }
    }

    @LogApi(methodCode="getVerifyResult", methodDescription="\u83b7\u53d6\u9a8c\u771f\u7ed3\u679c", systemType=SystemTypeEnum.IMAGE, isRetry=0, sender=SenderEnum.IMAGE, receiver=ReceiverEnum.PHOENIX)
    public String getVerifyResult(Long tenantId, String taskId) {
        try {
            MyThreadLocal.setObject(tenantId, taskId);
            String url = this.systemPaasSettings.getVerfiyResultUrl().replace("{tenant-id}", String.valueOf(tenantId)).replace("{task-id}", taskId);
            String token = this.paasTokenUtils.getLoginToken();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            headers.put("x-app-token", token);
            this.logger.debug("\u83b7\u53d6\u9a8c\u771f\u7ed3\u679c\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)tenantId, (Object)url);
            String responseStr = HttpUtils.doGet(url, headers, null);
            this.logger.debug("\u83b7\u53d6\u9a8c\u771f\u7ed3\u679c\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)tenantId, (Object)responseStr);
            return responseStr;
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u9a8c\u771f\u7ed3\u679c\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            throw new ElephantException("\u83b7\u53d6\u9a8c\u771f\u7ed3\u679c\u5931\u8d25", e);
        }
    }

    @LogApi(methodCode="checkBlacklist", methodDescription="\u9ed1\u540d\u5355\u68c0\u6d4b", systemType=SystemTypeEnum.IMAGE, isRetry=0, sender=SenderEnum.IMAGE, receiver=ReceiverEnum.PHOENIX)
    public List<String> checkBlacklist(Long tenantId, String ... taxNos) {
        try {
            MyThreadLocal.setObject(tenantId, taxNos.toString());
            String url = this.systemPaasSettings.getCheckBlacklistUrl().replace("{tenant-id}", String.valueOf(tenantId));
            String token = this.paasTokenUtils.getLoginToken();
            List<Long> sysOrgIds = this.paasTokenUtils.getSysOrgIds(tenantId);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            headers.put("x-app-token", token);
            JSONObject params = new JSONObject();
            params.put("keyWords", (Object)taxNos);
            params.put("sysOrgIds", sysOrgIds);
            params.put("tenantId", (Object)tenantId);
            this.logger.debug("\u53d1\u8d77\u9ed1\u540d\u5355\u68c0\u6d4b\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u5165\u53c2\uff1a{}", new Object[]{tenantId, url, JSON.toJSONString((Object)params)});
            String responseStr = HttpUtils.doJsonPost(url, headers, params.toJSONString());
            this.logger.debug("\u53d1\u8d77\u9ed1\u540d\u5355\u68c0\u6d4b\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)tenantId, (Object)responseStr);
            JSONObject resultObject = JSONObject.parseObject((String)responseStr);
            if (ValidatorUtil.isEmpty((Map)resultObject)) {
                this.logger.warn("\u53d1\u8d77\u9ed1\u540d\u5355\u68c0\u6d4b\u5f02\u5e38");
                throw new ElephantException("\u53d1\u8d77\u9ed1\u540d\u5355\u68c0\u6d4b\u5f02\u5e38");
            }
            String respCode = resultObject.getString("code");
            String respMsg = resultObject.getString("message");
            if (!"1".equals(respCode)) {
                throw new ElephantException(respMsg);
            }
            return (List)resultObject.getObject("result", (TypeReference)new TypeReference<List<String>>(){});
        }
        catch (Exception e) {
            this.logger.error("\u53d1\u8d77\u9ed1\u540d\u5355\u68c0\u6d4b\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new ElephantException("\u53d1\u8d77\u9ed1\u540d\u5355\u68c0\u6d4b\u5f02\u5e38", e);
        }
    }

    @LogApi(methodCode="checkSensitiveWord", methodDescription="\u654f\u611f\u8bcd\u68c0\u6d4b", systemType=SystemTypeEnum.IMAGE, isRetry=0, sender=SenderEnum.IMAGE, receiver=ReceiverEnum.PHOENIX)
    public List<String> checkSensitiveWord(Long tenantId, String content) {
        try {
            MyThreadLocal.setObject(tenantId, "");
            String url = this.systemPaasSettings.getCheckSensitiveWordsUrl().replace("{tenant-id}", String.valueOf(tenantId));
            String token = this.paasTokenUtils.getLoginToken();
            List<Long> sysOrgIds = this.paasTokenUtils.getSysOrgIds(tenantId);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            headers.put("x-app-token", token);
            JSONObject params = new JSONObject();
            params.put("keyWord", (Object)content);
            params.put("sysOrgIds", sysOrgIds);
            params.put("tenantId", (Object)tenantId);
            this.logger.debug("\u53d1\u8d77\u654f\u611f\u8bcd\u68c0\u6d4b\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u5165\u53c2\uff1a{}", new Object[]{tenantId, url, JSON.toJSONString((Object)params)});
            String responseStr = HttpUtils.doJsonPost(url, headers, params.toJSONString());
            this.logger.debug("\u53d1\u8d77\u654f\u611f\u8bcd\u68c0\u6d4b\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)tenantId, (Object)responseStr);
            JSONObject resultObject = JSONObject.parseObject((String)responseStr);
            if (ValidatorUtil.isEmpty((Map)resultObject)) {
                this.logger.warn("\u53d1\u8d77\u654f\u611f\u8bcd\u68c0\u6d4b\u5f02\u5e38");
                throw new ElephantException("\u53d1\u8d77\u654f\u611f\u8bcd\u68c0\u6d4b\u5f02\u5e38");
            }
            String respCode = resultObject.getString("code");
            String respMsg = resultObject.getString("message");
            if (!"1".equals(respCode)) {
                throw new ElephantException(respMsg);
            }
            return (List)resultObject.getObject("result", (TypeReference)new TypeReference<List<String>>(){});
        }
        catch (Exception e) {
            this.logger.error("\u53d1\u8d77\u654f\u611f\u8bcd\u68c0\u6d4b\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new ElephantException("\u53d1\u8d77\u654f\u611f\u8bcd\u68c0\u6d4b\u5f02\u5e38", e);
        }
    }
}

