/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.file;

import com.xforceplus.elephant.basecommon.enums.common.UploadTypeEnum;
import com.xforceplus.elephant.basecommon.file.FileStorage;
import com.xforceplus.elephant.basecommon.file.ftp.FTPUtils;
import com.xforceplus.elephant.basecommon.file.minio.MinioUtils;
import com.xforceplus.elephant.basecommon.file.oss.OSSUtils;
import com.xforceplus.elephant.basecommon.file.paas.PaasFileUtils;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class FileManager {
    private static final String UPLOAD_FILE_PATH = "elephant/%s/%s";
    @Value(value="${filestorage.updateType:}")
    private String updateType;
    @Autowired(required=false)
    private OSSUtils ossUtils;
    @Autowired(required=false)
    private FTPUtils ftpUtils;
    @Autowired(required=false)
    private MinioUtils minioUtils;
    @Autowired(required=false)
    private PaasFileUtils paasFileUtils;

    private FileStorage getFileStorage() {
        switch (UploadTypeEnum.valueOf(this.updateType)) {
            case FTP: {
                return this.ftpUtils;
            }
            case OSS: {
                return this.ossUtils;
            }
            case MINIO: {
                return this.minioUtils;
            }
            case PAAS: {
                return this.paasFileUtils;
            }
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u4e0a\u4f20\u65b9\u5f0f");
    }

    public String uploadFile(String fileName, InputStream stream) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        String fileKey = String.format(UPLOAD_FILE_PATH, sdf.format(new Date()), fileName);
        return this.uploadFileByFileKey(fileKey, stream);
    }

    public String uploadFileByFileKey(String fileKey, InputStream stream) {
        String result;
        FileStorage fileStorage = this.getFileStorage();
        if (fileStorage.getFileInputStream(result = fileStorage.uploadFileByInputStream(fileKey, stream)) != null) {
            return result;
        }
        return null;
    }

    public InputStream getFile(String fileKey) {
        FileStorage fileStorage = this.getFileStorage();
        return fileStorage.getFileInputStream(fileKey);
    }

    public boolean deleteFile(String ... fileKeys) {
        FileStorage fileStorage = this.getFileStorage();
        return fileStorage.deleteFiles(fileKeys);
    }
}

