/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.openapi;

import com.alibaba.fastjson.JSON;
import com.xforceplus.elephant.basecommon.exception.ElephantException;
import com.xforceplus.elephant.basecommon.help.HttpUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class OpenapiBillUtils {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public String syncTicketInfoForSAP(Long tenantId, List<Map<String, Object>> ticketList) {
        try {
            String url = "http://api.pscc-uat.shimaogroup.com/api-v1/ticketInfo";
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            String param = JSON.toJSONString(ticketList);
            this.logger.debug("\u63a8\u9001\u4e2a\u4eba\u5355\u8bc1\u6570\u636e\u540c\u6b65SAP\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u5165\u53c2\uff1a{}", new Object[]{tenantId, url, param});
            String responseStr = HttpUtils.doJsonPost(url, headers, JSON.toJSONString(ticketList));
            this.logger.debug("\u63a8\u9001\u4e2a\u4eba\u5355\u8bc1\u6570\u636e\u540c\u6b65SAP\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)tenantId, (Object)responseStr);
            return responseStr;
        }
        catch (Exception e) {
            this.logger.error("\u63a8\u9001\u4e2a\u4eba\u5355\u8bc1\u6570\u636e\u540c\u6b65SAP\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new ElephantException("\u63a8\u9001\u4e2a\u4eba\u5355\u8bc1\u6570\u636e\u540c\u6b65SAP\u5f02\u5e38", e);
        }
    }

    public String syncBillInvoiceForSAP(Long tenantId, List<Map<String, Object>> billTicketList) {
        try {
            String url = "http://api.pscc-uat.shimaogroup.com/api-v1/billInvoiceSync";
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            String param = JSON.toJSONString(billTicketList);
            this.logger.debug("\u63a8\u9001\u5355\u636e\u53ca\u5355\u8bc1\u6570\u636e\u540c\u6b65SAP\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u5165\u53c2\uff1a{}", new Object[]{tenantId, url, param});
            String responseStr = HttpUtils.doJsonPost(url, headers, JSON.toJSONString(billTicketList));
            this.logger.debug("\u63a8\u9001\u5355\u636e\u53ca\u5355\u8bc1\u6570\u636e\u540c\u6b65SAP\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)tenantId, (Object)responseStr);
            return responseStr;
        }
        catch (Exception e) {
            this.logger.error("\u63a8\u9001\u5355\u636e\u53ca\u5355\u8bc1\u6570\u636e\u540c\u6b65SAP\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new ElephantException("\u63a8\u9001\u5355\u636e\u53ca\u5355\u8bc1\u6570\u636e\u540c\u6b65SAP\u5f02\u5e38", e);
        }
    }
}

