/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.system.token;

import com.alibaba.fastjson.JSONObject;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.exceptions.TokenExpiredException;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.google.common.collect.Maps;
import com.xforceplus.elephant.basecommon.help.CompressionUtils;
import com.xforceplus.elephant.basecommon.system.token.ImagePageSettings;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TokenJwtUtils {
    private static final Logger logger = LoggerFactory.getLogger(TokenJwtUtils.class);
    private static String ISSUER = "xforceplus";
    @Autowired
    private ImagePageSettings imagePageSettings;

    public String getToken(String secret, Map<String, String> claims, Date expireDate) {
        try {
            TokenJwtUtils.checkSecret(secret);
            Algorithm ALGORITHM = Algorithm.HMAC256((String)secret);
            JWTCreator.Builder builder = JWT.create().withIssuer(ISSUER).withExpiresAt(expireDate).withClaim("iss", ISSUER);
            claims.forEach((arg_0, arg_1) -> ((JWTCreator.Builder)builder).withClaim(arg_0, arg_1));
            return builder.sign(ALGORITHM);
        }
        catch (Exception var5) {
            logger.error("\u751f\u6210token\u5f02\u5e38");
            return null;
        }
    }

    private static void checkSecret(String secret) {
        if (secret == null || secret.trim().equals("")) {
            throw new RuntimeException("\u5bc6\u94a5\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
    }

    public static Map<String, String> decodeToken(String token) throws TokenExpiredException {
        try {
            DecodedJWT decodedJWT = JWT.decode((String)token);
            Map<String, String> result = TokenJwtUtils.getStringMapFromClaim(token, decodedJWT);
            return result;
        }
        catch (Exception var3) {
            logger.warn(var3.getMessage());
            String message = "\u89e3\u6790token\u5931\u8d25";
            logger.error("token: " + token + ", " + message);
            return null;
        }
    }

    public static void verifyToken(String secret, String token) throws TokenExpiredException {
        try {
            Algorithm ALGORITHM = Algorithm.HMAC256((String)secret);
            JWTVerifier JWT_VERIFIER = JWT.require((Algorithm)ALGORITHM).withClaim("iss", ISSUER).build();
            JWT_VERIFIER.verify(token);
        }
        catch (TokenExpiredException var4) {
            logger.error("token\u8fc7\u671f\uff0ctoken=={}", (Object)token);
            throw var4;
        }
        catch (JWTVerificationException var5) {
            logger.error("token\u6821\u9a8c\u5931\u8d25\uff0ctoken=={}", (Object)token);
            throw var5;
        }
        catch (Exception var6) {
            throw new RuntimeException("\u89e3\u6790token\u5931\u8d25", var6);
        }
    }

    public static Map<String, String> verifyAndDecodeToken(String secret, String token) throws TokenExpiredException {
        TokenJwtUtils.verifyToken(secret, token);
        return TokenJwtUtils.decodeToken(token);
    }

    private static Map<String, String> getStringMapFromClaim(String token, DecodedJWT decodedJWT) {
        Map claims = decodedJWT.getClaims();
        if (claims.isEmpty()) {
            String message = "\u89e3\u6790token\u5931\u8d25";
            logger.error("token: " + token + ", " + message);
            throw new JWTDecodeException(message);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry entry : claims.entrySet()) {
            if (entry.getKey() == null) {
                logger.warn("entry.getKey() == null");
                continue;
            }
            if (entry.getValue() == null) {
                logger.warn("entry.getValue() == null");
                continue;
            }
            result.put((String)entry.getKey(), ((Claim)entry.getValue()).asString());
        }
        return result;
    }

    public Map<String, String> packageClaims() {
        HashMap claimsMap = Maps.newHashMap();
        claimsMap.put("type", "1");
        claimsMap.put("iss", ISSUER);
        claimsMap.put("tenant_secret_id", this.imagePageSettings.getTenantId());
        claimsMap.put("userid", this.imagePageSettings.getUserId());
        JSONObject jsonObject = new JSONObject();
        List appIdList = Arrays.stream(this.imagePageSettings.getAppIds().split(",")).map(r -> Integer.valueOf(r)).distinct().collect(Collectors.toList());
        jsonObject.put("appIds", appIdList);
        claimsMap.put("userinfo", CompressionUtils.encode(jsonObject.toJSONString(), 1));
        return claimsMap;
    }
}

