/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.help;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.help.NameUtils;
import com.xforceplus.elephant.basecommon.help.StringHelp;
import com.xforceplus.elephant.basecommon.log.LogApiEntity;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.cglib.core.Converter;

public class BeanUtils {
    private static Logger logger = LoggerFactory.getLogger(BeanUtils.class);
    private static final char UNDERLINE = '_';
    private static Map<String, BeanCopier> copierMap = new HashMap<String, BeanCopier>();
    private static PropertyConverter propertyConverter = new PropertyConverter();

    public static void copyProperties(Object src, Object dest) {
        try {
            BeanCopier copier;
            String key = src.getClass().getName() + dest.getClass().getName();
            if (copierMap.containsKey(key)) {
                copier = copierMap.get(key);
            } else {
                copier = BeanCopier.create(src.getClass(), dest.getClass(), (boolean)true);
                copierMap.put(key, copier);
            }
            copier.copy(src, dest, (Converter)propertyConverter);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u5c5e\u6027\u590d\u5236\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
        }
    }

    public static <T> T convertObject(Map<String, Object> entities, Class<T> tClass) {
        if (entities == null) {
            return null;
        }
        JSONObject obj = new JSONObject();
        entities.entrySet().forEach(entry -> {
            String key = (String)entry.getKey();
            if (key.contains(".")) {
                String[] keys = key.split("[.]");
                key = keys[keys.length - 1];
            }
            if (obj.containsKey((Object)key) && !key.equals(entry.getKey())) {
                return;
            }
            obj.put(NameUtils.firstLowerName(key), entry.getValue());
        });
        return (T)JSON.parseObject((String)obj.toJSONString(), tClass);
    }

    public static JSONObject convertJSON(Object obj) {
        if (obj == null) {
            return new JSONObject();
        }
        JSONObject json = JSON.parseObject((String)JSON.toJSONString((Object)obj));
        JSONObject result = new JSONObject();
        json.entrySet().forEach(entry -> result.put(NameUtils.cameName((String)entry.getKey()), entry.getValue()));
        return result;
    }

    public static JSONObject convertUnlineJSON(Object obj) {
        if (obj == null) {
            return new JSONObject();
        }
        JSONObject json = JSON.parseObject((String)JSON.toJSONString((Object)obj));
        JSONObject result = new JSONObject();
        json.entrySet().forEach(entry -> result.put(NameUtils.firstLowerName((String)entry.getKey()), entry.getValue()));
        return result;
    }

    public static <T> List<T> convertObject(List<Map<String, Object>> entityMaps, Class<T> tClass) {
        if (ValidatorUtil.isEmpty(entityMaps)) {
            return new ArrayList();
        }
        return entityMaps.stream().map(entityMap -> {
            JSONObject obj = new JSONObject();
            entityMap.entrySet().forEach(entry -> {
                String key = (String)entry.getKey();
                if (key.contains(".")) {
                    String[] keys = key.split("[.]");
                    key = keys[keys.length - 1];
                }
                if (obj.containsKey((Object)key) && !key.equals(entry.getKey())) {
                    return;
                }
                obj.put(NameUtils.firstLowerName(key), entry.getValue());
            });
            return JSON.parseObject((String)obj.toJSONString(), (Class)tClass);
        }).collect(Collectors.toList());
    }

    public static List<JSONObject> convertJSON(List<?> objs) {
        if (ValidatorUtil.isEmpty(objs)) {
            return new ArrayList<JSONObject>();
        }
        return objs.stream().map(obj -> {
            JSONObject json = JSON.parseObject((String)JSON.toJSONString((Object)obj));
            JSONObject result = new JSONObject();
            json.entrySet().forEach(entry -> result.put(NameUtils.cameName((String)entry.getKey()), entry.getValue()));
            return result;
        }).collect(Collectors.toList());
    }

    public static JSONObject convertObjectToJSON(Object obj, Class clazz) {
        JSONObject jsonObject = new JSONObject();
        try {
            Field[] fields;
            for (Field field : fields = obj.getClass().getDeclaredFields()) {
                String dstName = BeanUtils.camelToUnderline(field.getName());
                PropertyDescriptor pd = new PropertyDescriptor(field.getName(), clazz);
                Method method = pd.getReadMethod();
                jsonObject.put(dstName, method.invoke(obj, new Object[0]));
            }
        }
        catch (Exception e) {
            logger.error("src value:[{}],target class:[{}]\u7c7b\u578b\u8f6c\u6362\u9519\u8bef", new Object[]{obj, clazz, e});
        }
        return jsonObject;
    }

    public static String camelToUnderline(String param) {
        if (StringHelp.safeIsEmpty(param)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int len = param.length();
        for (int i = 0; i < len; ++i) {
            char c = param.charAt(i);
            if (Character.isUpperCase(c)) {
                sb.append('_');
                sb.append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("is_retry", 0);
        map.put("a.b.c.method_code", "code");
        map.put("method_description", "test");
        LogApiEntity entity = BeanUtils.convertObject(map, LogApiEntity.class);
        System.out.println(entity);
    }

    private static class PropertyConverter
    implements Converter {
        private PropertyConverter() {
        }

        public Object convert(Object value, Class target, Object context) {
            if (value == null) {
                return null;
            }
            try {
                if (!value.getClass().equals(target)) {
                    if (target.equals(BigDecimal.class)) {
                        return new BigDecimal(value.toString());
                    }
                    if (target.equals(Long.class)) {
                        if (value.getClass().equals(Date.class)) {
                            return ((Date)value).getTime();
                        }
                        return Long.valueOf(value.toString());
                    }
                    if (target.equals(Integer.class)) {
                        return Integer.valueOf(value.toString());
                    }
                    if (target.equals(Integer.TYPE)) {
                        return (int)Integer.valueOf(value.toString());
                    }
                    if (target.equals(String.class)) {
                        return value.toString();
                    }
                    if (target.isEnum()) {
                        return Enum.valueOf(target, value.toString());
                    }
                    if (target.equals(Date.class) && value.getClass().equals(Long.class)) {
                        return new Date(Long.parseLong(value.toString()));
                    }
                }
                return value;
            }
            catch (Exception e) {
                logger.error("src value:[{}],target class:[{}]\u7c7b\u578b\u8f6c\u6362\u9519\u8bef", new Object[]{value, target, e});
                return null;
            }
        }
    }
}

