/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.system.paas;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.xforceplus.elephant.basecommon.annotation.LogApi;
import com.xforceplus.elephant.basecommon.enums.log.ReceiverEnum;
import com.xforceplus.elephant.basecommon.enums.log.SenderEnum;
import com.xforceplus.elephant.basecommon.enums.log.SystemTypeEnum;
import com.xforceplus.elephant.basecommon.exception.ElephantException;
import com.xforceplus.elephant.basecommon.help.HttpUtils;
import com.xforceplus.elephant.basecommon.log.MyThreadLocal;
import com.xforceplus.elephant.basecommon.system.paas.SystemPaasSettings;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;

@Component
public class PaasTokenUtils {
    private Logger logger = LoggerFactory.getLogger(PaasTokenUtils.class);
    @Autowired
    private SystemPaasSettings systemPaasSettings;

    @Cacheable(cacheNames={"paasToken"}, unless="#result == null || #result == ''")
    public String getLoginToken() {
        String token = "";
        try {
            JSONObject reqJson = new JSONObject();
            reqJson.put("clientId", (Object)this.systemPaasSettings.getClientId());
            reqJson.put("secret", (Object)this.systemPaasSettings.getSecret());
            this.logger.debug("paas\u767b\u5f55token\u4fe1\u606f\u8bf7\u6c42\u5730\u5740\uff1a{},\u8bf7\u6c42\u5165\u53c2\uff1a{}", (Object)this.systemPaasSettings.getTokenUrl(), (Object)reqJson.toJSONString());
            String tokenJson = HttpUtils.doJsonPost(this.systemPaasSettings.getTokenUrl(), reqJson.toJSONString());
            this.logger.debug("paas\u767b\u5f55token\u4fe1\u606f\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)tokenJson);
            JSONObject jsonObj = (JSONObject)JSON.parseObject((String)tokenJson, JSONObject.class);
            if (ValidatorUtil.isEmpty((Map)jsonObj)) {
                return token;
            }
            Integer code = (Integer)jsonObj.get((Object)"code");
            if (code == 1) {
                token = (String)jsonObj.get((Object)"data");
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6paas\u767b\u5f55token\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new ElephantException("\u83b7\u53d6paas\u767b\u5f55token\u5f02\u5e38", e);
        }
        return token;
    }

    @LogApi(methodCode="getSysOrgInfo", methodDescription="\u7ec4\u7ec7\u4fe1\u606f\u67e5\u8be2", systemType=SystemTypeEnum.IMAGE, isRetry=0, sender=SenderEnum.IMAGE, receiver=ReceiverEnum.PHOENIX)
    public JSONObject getSysOrgInfo(Long tenantId, boolean isOrg, String taxNum, String companyName) {
        try {
            MyThreadLocal.setObject(tenantId, taxNum);
            String url = this.systemPaasSettings.getSelectSysOrgUrl().replace("{tenantId}", String.valueOf(tenantId));
            String token = this.getLoginToken();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            headers.put("x-app-token", token);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("tenantId", String.valueOf(tenantId));
            params.put("status", "1");
            if (isOrg) {
                params.put("rootOrg", "true");
            } else {
                params.put("taxNum", taxNum);
                params.put("companyName", companyName);
            }
            this.logger.debug("\u53d1\u8d77\u6839\u7ec4\u7ec7\u67e5\u8be2\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u5165\u53c2\uff1a{}", new Object[]{tenantId, url, JSON.toJSONString(params)});
            String responseStr = HttpUtils.doGet(url, headers, params);
            this.logger.debug("\u53d1\u8d77\u6839\u7ec4\u7ec7\u67e5\u8be2\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)tenantId, (Object)responseStr);
            JSONObject resultObject = JSONObject.parseObject((String)responseStr);
            if (ValidatorUtil.isEmpty((Map)resultObject)) {
                this.logger.warn("\u53d1\u8d77\u6839\u7ec4\u7ec7\u67e5\u8be2\u5f02\u5e38");
                throw new ElephantException("\u53d1\u8d77\u6839\u7ec4\u7ec7\u67e5\u8be2\u5f02\u5e38");
            }
            String respCode = resultObject.getString("code");
            String respMsg = resultObject.getString("message");
            if (!"1".equals(respCode)) {
                throw new ElephantException(respMsg);
            }
            return (JSONObject)resultObject.getObject("result", (TypeReference)new TypeReference<JSONObject>(){});
        }
        catch (Exception e) {
            this.logger.error("\u53d1\u8d77\u6839\u7ec4\u7ec7\u67e5\u8be2\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new ElephantException("\u53d1\u8d77\u6839\u7ec4\u7ec7\u67e5\u8be2\u5f02\u5e38", e);
        }
    }

    @LogApi(methodCode="getSysOrgIds", methodDescription="\u83b7\u53d6\u7ec4\u7ec7ID\u96c6\u5408", systemType=SystemTypeEnum.IMAGE, isRetry=0, sender=SenderEnum.IMAGE, receiver=ReceiverEnum.PHOENIX)
    @Cacheable(cacheNames={"sysOrgIds"}, key="#root.args[0]", unless="#result == null || #result == ''")
    public List<Long> getSysOrgIds(Long tenantId) {
        try {
            MyThreadLocal.setObject(tenantId, "");
            JSONObject resultObject = this.getSysOrgInfo(tenantId, true, "", "");
            if (null == resultObject) {
                this.logger.error("\u7ec4\u7ec7\u4fe1\u606f\u67e5\u8be2\u5931\u8d25");
            }
            ArrayList<Long> sysOrgIds = new ArrayList<Long>();
            JSONArray orgs = resultObject.getJSONArray("content");
            for (int i = 0; i < orgs.size(); ++i) {
                JSONObject org = orgs.getJSONObject(i);
                sysOrgIds.add(org.getLongValue("orgId"));
            }
            return sysOrgIds;
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u7ec4\u7ec7ID\u96c6\u5408\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new ElephantException("\u83b7\u53d6\u7ec4\u7ec7ID\u96c6\u5408\u5f02\u5e38", e);
        }
    }
}

