/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.openapi;

import com.alibaba.fastjson.JSON;
import com.xforceplus.elephant.basecommon.annotation.LogApi;
import com.xforceplus.elephant.basecommon.enums.log.ReceiverEnum;
import com.xforceplus.elephant.basecommon.enums.log.SenderEnum;
import com.xforceplus.elephant.basecommon.enums.log.SystemTypeEnum;
import com.xforceplus.elephant.basecommon.exception.ElephantException;
import com.xforceplus.elephant.basecommon.help.HttpUtils;
import com.xforceplus.elephant.basecommon.help.StringHelp;
import com.xforceplus.elephant.basecommon.log.MyThreadLocal;
import com.xforceplus.elephant.basecommon.openapi.OpenapiSettings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OpenapiWilmarUtils {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private OpenapiSettings openapiSettings;

    @LogApi(methodCode="origBackHandleResult", methodDescription="\u539f\u4ef6\u9000\u56de\u5904\u7406\u7ed3\u679c\u540c\u6b65EPM/MK", systemType=SystemTypeEnum.IMAGE, isRetry=0, sender=SenderEnum.IMAGE, receiver=ReceiverEnum.JANUS)
    public String origBackHandleResult(Long tenantId, String billCode, String status, String systemOrig) {
        try {
            MyThreadLocal.setObject(tenantId, billCode, billCode);
            if (StringHelp.safeIsEmpty(this.openapiSettings.getTicketInfoSyncUrl())) {
                return "\u539f\u4ef6\u9000\u56de\u5904\u7406\u7ed3\u679c\u540c\u6b65EPM/MK\u5931\u8d25\uff0c\u63a5\u53e3\u5730\u5740\u4e3a\u7a7a";
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("businessId", billCode);
            params.put("status", status);
            this.logger.debug("\u539f\u4ef6\u9000\u56de\u5904\u7406\u7ed3\u679c\u540c\u6b65EPM/MK\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u5165\u53c2\uff1a{}", new Object[]{tenantId, this.openapiSettings.getTicketInfoSyncUrl(), JSON.toJSONString(params)});
            String responseStr = HttpUtils.doJsonPost(this.openapiSettings.getTicketInfoSyncUrl(), headers, JSON.toJSONString(params));
            this.logger.debug("\u539f\u4ef6\u9000\u56de\u5904\u7406\u7ed3\u679c\u540c\u6b65EPM/MK\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)tenantId, (Object)responseStr);
            return responseStr;
        }
        catch (Exception e) {
            this.logger.error("\u539f\u4ef6\u9000\u56de\u5904\u7406\u7ed3\u679c\u540c\u6b65EPM/MK\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new ElephantException("\u539f\u4ef6\u9000\u56de\u5904\u7406\u7ed3\u679c\u540c\u6b65EPM/MK\u5f02\u5e38", e);
        }
    }

    @LogApi(methodCode="syncImageUploadInfo", methodDescription="\u540c\u6b65\u5f71\u50cf\u4e0a\u4f20\u4fe1\u606f\u7ed9sharepoint", systemType=SystemTypeEnum.IMAGE, isRetry=0, sender=SenderEnum.IMAGE, receiver=ReceiverEnum.JANUS)
    public String syncImageUploadInfo(Long tenantId, String billCode, String invoiceNo, String invoiceCode, Map<String, Object> imageMap) {
        try {
            MyThreadLocal.setObject(tenantId, billCode, billCode, invoiceNo, invoiceCode);
            if (StringHelp.safeIsEmpty(this.openapiSettings.getTicketInfoSyncUrl())) {
                return "\u540c\u6b65\u5f71\u50cf\u4e0a\u4f20\u4fe1\u606f\u7ed9sharepoint\u5931\u8d25\uff0c\u63a5\u53e3\u5730\u5740\u4e3a\u7a7a";
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            String param = JSON.toJSONString(imageMap);
            this.logger.debug("\u540c\u6b65\u5f71\u50cf\u4e0a\u4f20\u4fe1\u606f\u7ed9sharepoint\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u5165\u53c2\uff1a{}", new Object[]{tenantId, this.openapiSettings.getTicketInfoSyncUrl(), param});
            String responseStr = HttpUtils.doJsonPost(this.openapiSettings.getTicketInfoSyncUrl(), headers, param);
            this.logger.debug("\u540c\u6b65\u5f71\u50cf\u4e0a\u4f20\u4fe1\u606f\u7ed9sharepoint\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)tenantId, (Object)responseStr);
            return responseStr;
        }
        catch (Exception e) {
            this.logger.error("\u540c\u6b65\u5f71\u50cf\u4e0a\u4f20\u4fe1\u606f\u7ed9sharepoint\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new ElephantException("\u540c\u6b65\u5f71\u50cf\u4e0a\u4f20\u4fe1\u606f\u7ed9sharepoint\u5f02\u5e38", e);
        }
    }

    @LogApi(methodCode="syncImageDeleteInfo", methodDescription="\u540c\u6b65\u5f71\u50cf\u5220\u9664\u4fe1\u606f\u7ed9sharepoint", systemType=SystemTypeEnum.IMAGE, isRetry=0, sender=SenderEnum.IMAGE, receiver=ReceiverEnum.JANUS)
    public String syncImageDeleteInfo(Long tenantId, String billCode, String invoiceNo, String invoiceCode, Map<String, Object> imageMap) {
        try {
            MyThreadLocal.setObject(tenantId, billCode, billCode, invoiceNo, invoiceCode);
            if (StringHelp.safeIsEmpty(this.openapiSettings.getTicketInfoSyncUrl())) {
                return "\u540c\u6b65\u5f71\u50cf\u5220\u9664\u4fe1\u606f\u7ed9sharepoint\u5931\u8d25\uff0c\u63a5\u53e3\u5730\u5740\u4e3a\u7a7a";
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            String param = JSON.toJSONString(imageMap);
            this.logger.debug("\u540c\u6b65\u5f71\u50cf\u5220\u9664\u4fe1\u606f\u7ed9sharepoint\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u5165\u53c2\uff1a{}", new Object[]{tenantId, this.openapiSettings.getTicketInfoSyncUrl(), param});
            String responseStr = HttpUtils.doJsonPost(this.openapiSettings.getTicketInfoSyncUrl(), headers, param);
            this.logger.debug("\u540c\u6b65\u5f71\u50cf\u5220\u9664\u4fe1\u606f\u7ed9sharepoint\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)tenantId, (Object)responseStr);
            return responseStr;
        }
        catch (Exception e) {
            this.logger.error("\u540c\u6b65\u5f71\u50cf\u5220\u9664\u4fe1\u606f\u7ed9sharepoint\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new ElephantException("\u540c\u6b65\u5f71\u50cf\u5220\u9664\u4fe1\u606f\u7ed9sharepoint\u5f02\u5e38", e);
        }
    }

    @LogApi(methodCode="syncImageModifyInfo", methodDescription="\u540c\u6b65\u53d1\u7968\u4fee\u6539\u4fe1\u606f\u7ed9sharepoint", systemType=SystemTypeEnum.IMAGE, isRetry=0, sender=SenderEnum.IMAGE, receiver=ReceiverEnum.JANUS)
    public String syncImageModifyInfo(Long tenantId, String billCode, String invoiceNo, String invoiceCode, Map<String, Object> imageMap) {
        try {
            MyThreadLocal.setObject(tenantId, billCode, billCode, invoiceNo, invoiceCode);
            if (StringHelp.safeIsEmpty(this.openapiSettings.getTicketInfoSyncUrl())) {
                return "\u540c\u6b65\u53d1\u7968\u4fee\u6539\u4fe1\u606f\u7ed9sharepoint\u5931\u8d25\uff0c\u63a5\u53e3\u5730\u5740\u4e3a\u7a7a";
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            String param = JSON.toJSONString(imageMap);
            this.logger.debug("\u540c\u6b65\u53d1\u7968\u4fee\u6539\u4fe1\u606f\u7ed9sharepoint\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u5165\u53c2\uff1a{}", new Object[]{tenantId, this.openapiSettings.getTicketInfoSyncUrl(), param});
            String responseStr = HttpUtils.doJsonPost(this.openapiSettings.getTicketInfoSyncUrl(), headers, param);
            this.logger.debug("\u540c\u6b65\u53d1\u7968\u4fee\u6539\u4fe1\u606f\u7ed9sharepoint\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)tenantId, (Object)responseStr);
            return responseStr;
        }
        catch (Exception e) {
            this.logger.error("\u540c\u6b65\u53d1\u7968\u4fee\u6539\u4fe1\u606f\u7ed9sharepoint\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new ElephantException("\u540c\u6b65\u53d1\u7968\u4fee\u6539\u4fe1\u606f\u7ed9sharepoint\u5f02\u5e38", e);
        }
    }

    @LogApi(methodCode="syncOriginalBackInfo", methodDescription="\u540c\u6b65\u53d6\u56de\u539f\u4ef6\u7ed9sharepoint", systemType=SystemTypeEnum.IMAGE, isRetry=0, sender=SenderEnum.IMAGE, receiver=ReceiverEnum.JANUS)
    public String syncOriginalBackInfo(Long tenantId, String billCode, List<String> imageUrl) {
        try {
            MyThreadLocal.setObject(tenantId, billCode, billCode);
            if (StringHelp.safeIsEmpty(this.openapiSettings.getTicketInfoSyncUrl())) {
                return "\u540c\u6b65\u53d6\u56de\u539f\u4ef6\u7ed9sharepoint\u5931\u8d25\uff0c\u63a5\u53e3\u5730\u5740\u4e3a\u7a7a";
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("barCode", billCode);
            params.put("invoices", imageUrl);
            String paramStr = JSON.toJSONString(params);
            this.logger.debug("\u540c\u6b65\u53d6\u56de\u539f\u4ef6\u7ed9sharepoint\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u5165\u53c2\uff1a{}", new Object[]{tenantId, this.openapiSettings.getTicketInfoSyncUrl(), paramStr});
            String responseStr = HttpUtils.doJsonPost(this.openapiSettings.getTicketInfoSyncUrl(), headers, paramStr);
            this.logger.debug("\u540c\u6b65\u53d6\u56de\u539f\u4ef6\u7ed9sharepoint\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)tenantId, (Object)responseStr);
            return responseStr;
        }
        catch (Exception e) {
            this.logger.error("\u540c\u6b65\u53d6\u56de\u539f\u4ef6\u7ed9sharepoint\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new ElephantException("\u540c\u6b65\u53d6\u56de\u539f\u4ef6\u7ed9sharepoint\u5f02\u5e38", e);
        }
    }

    @LogApi(methodCode="syncImageUrlExpense", methodDescription="\u5355\u636e\u5e26\u6709MK\u6807\u8bc6\u540c\u6b65\u5f71\u50cf\u5730\u5740MK", systemType=SystemTypeEnum.IMAGE, isRetry=0, sender=SenderEnum.IMAGE, receiver=ReceiverEnum.JANUS)
    public String syncImageUrlExpense(Long tenantId, String billCode, List<String> imageUrls) {
        try {
            MyThreadLocal.setObject(tenantId, billCode, billCode);
            if (StringHelp.safeIsEmpty(this.openapiSettings.getTicketInfoSyncUrl())) {
                return "\u5355\u636e\u5e26\u6709MK\u6807\u8bc6\u540c\u6b65\u5f71\u50cf\u5730\u5740MK\u5931\u8d25\uff0c\u63a5\u53e3\u5730\u5740\u4e3a\u7a7a";
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("billCode", billCode);
            params.put("invoiceImageUrls", imageUrls);
            this.logger.debug("\u5355\u636e\u5e26\u6709MK\u6807\u8bc6\u540c\u6b65\u5f71\u50cf\u5730\u5740MK\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u5165\u53c2\uff1a{}", new Object[]{tenantId, this.openapiSettings.getTicketInfoSyncUrl(), JSON.toJSONString(params)});
            String responseStr = HttpUtils.doJsonPost(this.openapiSettings.getTicketInfoSyncUrl(), headers, JSON.toJSONString(params));
            this.logger.debug("\u5355\u636e\u5e26\u6709MK\u6807\u8bc6\u540c\u6b65\u5f71\u50cf\u5730\u5740MK\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)tenantId, (Object)responseStr);
            return responseStr;
        }
        catch (Exception e) {
            this.logger.error("\u5355\u636e\u5e26\u6709MK\u6807\u8bc6\u540c\u6b65\u5f71\u50cf\u5730\u5740MK\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new ElephantException("\u5355\u636e\u5e26\u6709MK\u6807\u8bc6\u540c\u6b65\u5f71\u50cf\u5730\u5740MK\u5f02\u5e38", e);
        }
    }

    @LogApi(methodCode="syncBillTicketInfoForSAP", methodDescription="\u540c\u6b65\u5c01\u9762\u53d1\u7968\u6e05\u5355\u7ed9SAP", systemType=SystemTypeEnum.IMAGE, isRetry=0, sender=SenderEnum.IMAGE, receiver=ReceiverEnum.JANUS)
    public String syncBillTicketInfoForSAP(Long tenantId, String billCode, List<Map<String, Object>> billTicketList) {
        try {
            MyThreadLocal.setObject(tenantId, billCode, billCode);
            if (StringHelp.safeIsEmpty(this.openapiSettings.getTicketInfoSyncUrl())) {
                return "\u540c\u6b65\u5c01\u9762\u53d1\u7968\u6e05\u5355\u7ed9SAP\u5931\u8d25\uff0c\u63a5\u53e3\u5730\u5740\u4e3a\u7a7a";
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            String param = JSON.toJSONString(billTicketList);
            this.logger.debug("\u540c\u6b65\u5c01\u9762\u53d1\u7968\u6e05\u5355\u7ed9SAP\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u5165\u53c2\uff1a{}", new Object[]{tenantId, this.openapiSettings.getTicketInfoSyncUrl(), param});
            String responseStr = HttpUtils.doJsonPost(this.openapiSettings.getTicketInfoSyncUrl(), headers, param);
            this.logger.debug("\u540c\u6b65\u5c01\u9762\u53d1\u7968\u6e05\u5355\u7ed9SAP\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)tenantId, (Object)responseStr);
            return responseStr;
        }
        catch (Exception e) {
            this.logger.error("\u540c\u6b65\u5c01\u9762\u53d1\u7968\u6e05\u5355\u7ed9SAP\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new ElephantException("\u540c\u6b65\u5c01\u9762\u53d1\u7968\u6e05\u5355\u7ed9SAP\u5f02\u5e38", e);
        }
    }

    @LogApi(methodCode="syncBillImageInfoForEPM", methodDescription="\u540c\u6b65\u5ba1\u6838\u4fe1\u606f\u7ed9EPM", systemType=SystemTypeEnum.IMAGE, isRetry=0, sender=SenderEnum.IMAGE, receiver=ReceiverEnum.JANUS)
    public String syncBillImageInfoForEPM(Long tenantId, String billCode, List<Map<String, Object>> billTicketList) {
        try {
            MyThreadLocal.setObject(tenantId, billCode, billCode);
            if (StringHelp.safeIsEmpty(this.openapiSettings.getTicketInfoSyncUrl())) {
                return "\u540c\u6b65\u5ba1\u6838\u4fe1\u606f\u7ed9EPM\u5931\u8d25\uff0c\u63a5\u53e3\u5730\u5740\u4e3a\u7a7a";
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            String param = JSON.toJSONString(billTicketList);
            this.logger.debug("\u540c\u6b65\u5ba1\u6838\u4fe1\u606f\u7ed9EPM\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u5165\u53c2\uff1a{}", new Object[]{tenantId, this.openapiSettings.getTicketInfoSyncUrl(), param});
            String responseStr = HttpUtils.doJsonPost(this.openapiSettings.getTicketInfoSyncUrl(), headers, param);
            this.logger.debug("\u540c\u6b65\u5ba1\u6838\u4fe1\u606f\u7ed9EPM\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)tenantId, (Object)responseStr);
            return responseStr;
        }
        catch (Exception e) {
            this.logger.error("\u540c\u6b65\u5ba1\u6838\u4fe1\u606f\u7ed9EPM\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new ElephantException("\u540c\u6b65\u5ba1\u6838\u4fe1\u606f\u7ed9EPM\u5f02\u5e38", e);
        }
    }
}

