/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.log;

import com.xforceplus.elephant.basecommon.annotation.LogApi;
import com.xforceplus.elephant.basecommon.enums.log.IsSuccessEnum;
import com.xforceplus.elephant.basecommon.enums.log.ReceiverEnum;
import com.xforceplus.elephant.basecommon.enums.log.SenderEnum;
import com.xforceplus.elephant.basecommon.enums.log.SystemTypeEnum;
import com.xforceplus.elephant.basecommon.help.JsonHelp;
import com.xforceplus.elephant.basecommon.log.LogApiEntity;
import com.xforceplus.elephant.basecommon.log.MainHeader;
import com.xforceplus.elephant.basecommon.log.MyThreadLocal;
import com.xforceplus.elephant.basecommon.rabbitmq.RabbitmqUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.Date;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

@Aspect
@Component
public class LogAspect {
    @Resource
    HttpServletRequest httpServletRequest;
    private static Logger logger = LoggerFactory.getLogger(LogAspect.class);
    @Autowired
    private RabbitmqUtils rabbitmqUtils;

    @Pointcut(value="@annotation(com.xforceplus.elephant.basecommon.annotation.LogApi)")
    public void logPoint() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="logPoint()")
    public Object aroundMethod(JoinPoint joinPoint) throws Exception {
        StopWatch stopWatch = new StopWatch(joinPoint.getSignature().getName());
        LogApiEntity logApiEntity = new LogApiEntity();
        joinPoint.getSignature().getDeclaringType();
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        Object object = null;
        String targetName = joinPoint.getTarget().getClass().getName();
        Class<?> targetClass = Class.forName(targetName);
        Method[] methods = targetClass.getMethods();
        String methodName = joinPoint.getSignature().getName();
        String methodDescription = "";
        String sender = "";
        String receiver = "";
        String params = "";
        String methodCode = "";
        int systemType = 0;
        int isRetry = 0;
        if (joinPoint.getArgs() != null && joinPoint.getArgs().length > 0) {
            for (Object objects : joinPoint.getArgs()) {
                params = params + JsonHelp.toString(objects) + ";";
            }
        }
        for (Method method : methods) {
            if (!method.getName().equals(methodName)) continue;
            methodDescription = method.getAnnotation(LogApi.class).methodDescription();
            methodCode = method.getAnnotation(LogApi.class).methodCode();
            SenderEnum senderEnum = method.getAnnotation(LogApi.class).sender();
            sender = null != senderEnum ? senderEnum.getCode() : SenderEnum.DEFAULT.getCode();
            ReceiverEnum receiverEnum = method.getAnnotation(LogApi.class).receiver();
            receiver = null != receiverEnum ? receiverEnum.getCode() : ReceiverEnum.DEFAULT.getCode();
            SystemTypeEnum systemTypeEnum = method.getAnnotation(LogApi.class).systemType();
            systemType = null != systemTypeEnum ? systemTypeEnum.getCode() : SystemTypeEnum.DEFAULT.getCode();
            isRetry = method.getAnnotation(LogApi.class).isRetry();
            break;
        }
        logApiEntity.setCreateTime(new Date());
        logApiEntity.setCreateUser("\u7cfb\u7edf");
        logApiEntity.setMethodName(methodName);
        logApiEntity.setMethodDescription(methodDescription);
        logApiEntity.setParams(params);
        logApiEntity.setSender(sender);
        logApiEntity.setReceiver(receiver);
        logApiEntity.setMethodCode(methodCode);
        logApiEntity.setSystemType(systemType);
        logApiEntity.setIsRetry(isRetry);
        logApiEntity.setExceptionDetail("");
        try {
            logApiEntity.setMethodUrl(this.httpServletRequest.getRequestURI());
        }
        catch (Exception e) {
            logger.error("setMethodUrl\u6267\u884c\u5f02\u5e38");
        }
        try {
            stopWatch.start();
            object = ((ProceedingJoinPoint)joinPoint).proceed();
            stopWatch.stop();
            MainHeader mainHeader = MyThreadLocal.getObject();
            MyThreadLocal.removeObject();
            logApiEntity.setIsSuccess(IsSuccessEnum.SUCCESS.getCode());
            logApiEntity.setTenantId(mainHeader.getTenantId());
            logApiEntity.setNumber(mainHeader.getNumber());
            logApiEntity.setBillCode(mainHeader.getBillCode());
            logApiEntity.setInvoiceNo(mainHeader.getInvoiceNo());
            logApiEntity.setInvoiceCode(mainHeader.getInvoiceCode());
            logApiEntity.setResult(JsonHelp.toString(object));
            logApiEntity.setExecutionTime(JsonHelp.toString(stopWatch.getTotalTimeSeconds()));
        }
        catch (Exception e) {
            MainHeader mainHeader = MyThreadLocal.getObject();
            MyThreadLocal.removeObject();
            logApiEntity.setTenantId(mainHeader.getTenantId());
            logApiEntity.setNumber(mainHeader.getNumber());
            logApiEntity.setBillCode(mainHeader.getBillCode());
            logApiEntity.setInvoiceNo(mainHeader.getInvoiceNo());
            logApiEntity.setInvoiceCode(mainHeader.getInvoiceCode());
            logApiEntity.setIsSuccess(IsSuccessEnum.FAIL.getCode());
            e.printStackTrace(printWriter);
            StringBuffer buffer = stringWriter.getBuffer();
            logApiEntity.setExceptionDetail(buffer.toString());
            logApiEntity.setResult(buffer.toString());
            printWriter.flush();
        }
        finally {
            if (stringWriter != null) {
                try {
                    stringWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (printWriter != null) {
                printWriter.close();
            }
            this.rabbitmqUtils.sendByDirectExchange("imageApiLogQueue", logApiEntity);
            return object;
        }
    }
}

