/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.system.paas;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.annotation.LogApi;
import com.xforceplus.elephant.basecommon.enums.log.ReceiverEnum;
import com.xforceplus.elephant.basecommon.enums.log.SenderEnum;
import com.xforceplus.elephant.basecommon.enums.log.SystemTypeEnum;
import com.xforceplus.elephant.basecommon.exception.ElephantException;
import com.xforceplus.elephant.basecommon.help.HttpUtils;
import com.xforceplus.elephant.basecommon.log.MyThreadLocal;
import com.xforceplus.elephant.basecommon.system.paas.PaasTokenUtils;
import com.xforceplus.elephant.basecommon.system.paas.SystemPaasSettings;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class NotificationUtils {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SystemPaasSettings systemPaasSettings;
    @Autowired
    private PaasTokenUtils paasTokenUtils;
    @Value(value="${xforce.tenant_security.appid:0}")
    private String appId;

    public boolean sendSingleMessage(Long tenantId, List<Long> receiverIds, String title, String content) {
        return this.sendMessage(tenantId, "SINGLE", 0, null, receiverIds, title, content, null);
    }

    @LogApi(methodCode="sendMessage", methodDescription="\u53d1\u9001\u6d88\u606f", systemType=SystemTypeEnum.IMAGE, isRetry=0, sender=SenderEnum.IMAGE, receiver=ReceiverEnum.PHOENIX)
    public boolean sendMessage(Long tenantId, String scope, Integer type, Long senderId, List<Long> receiverIds, String title, String content, List<String> tags) {
        try {
            MyThreadLocal.setObject(tenantId, title);
            if ("SINGLE".equals(scope) && ValidatorUtil.isEmpty(receiverIds)) {
                throw new ElephantException("\u4e2a\u4eba\u6d88\u606f\u4e0d\u80fd\u7f3a\u5c11\u63a5\u6536\u8005");
            }
            type = type != null ? type : 0;
            JSONObject params = new JSONObject();
            params.put("scope", (Object)scope);
            params.put("type", (Object)type);
            if (senderId != null) {
                params.put("senderId", (Object)senderId);
            }
            if (ValidatorUtil.isNotEmpty(receiverIds)) {
                params.put("receiverIds", receiverIds);
            }
            params.put("title", (Object)title);
            params.put("content", (Object)content);
            if (ValidatorUtil.isNotEmpty(tags)) {
                params.put("tags", tags);
            }
            String token = this.paasTokenUtils.getLoginToken();
            HashMap<String, String> headerParam = new HashMap<String, String>();
            headerParam.put("Content-Type", "application/json");
            headerParam.put("x-app-token", token);
            String url = this.systemPaasSettings.getNotificationInsertUrl().replace("{tenantId}", String.valueOf(tenantId));
            url = url + "?appId=" + this.appId;
            this.logger.debug("\u6dfb\u52a0\u7ad9\u5185\u4fe1\u4fe1\u606f\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u5165\u53c2\uff1a{}", new Object[]{tenantId, url, params});
            String response = HttpUtils.doJsonPost(url, headerParam, params.toJSONString());
            JSONObject resultObject = JSONObject.parseObject((String)response);
            String respCode = resultObject.getString("code");
            String respMsg = resultObject.getString("message");
            if (!"NTCTZZ0001".equals(respCode)) {
                throw new ElephantException(respMsg);
            }
        }
        catch (Exception e) {
            this.logger.error("\u6dfb\u52a0\u7ad9\u5185\u4fe1\u4fe1\u606f\u5f02\u5e38\uff0c\u79df\u6237ID\uff1a" + tenantId + "\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + e.getMessage(), (Throwable)e);
        }
        return true;
    }
}

