/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.help;

import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import java.math.BigDecimal;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.CharUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class StringHelp {
    private StringHelp() {
    }

    public static String safeToString(Object obj) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof Date) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return formatter.format(obj);
        }
        return obj.toString();
    }

    public static boolean safeIsEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        return StringUtils.isBlank((CharSequence)obj.toString());
    }

    public static boolean safeIsNotEmpty(Object obj) {
        if (obj == null) {
            return false;
        }
        return !StringUtils.isBlank((CharSequence)obj.toString());
    }

    public static String safeTrim(String str) {
        if (str == null) {
            return "";
        }
        return str.trim();
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs != null && (strLen = cs.length()) != 0) {
            for (int i = 0; i < strLen; ++i) {
                if (Character.isWhitespace(cs.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static String replaceBlank(String str_content) {
        if (null == str_content) {
            return "";
        }
        String res = "";
        Pattern p = Pattern.compile("\t|\r|\n");
        Matcher m = p.matcher(str_content);
        res = m.replaceAll("");
        return res;
    }

    public static char safeStringToChar(String str) {
        return CharUtils.toChar((String)str);
    }

    public static int safeStringToInt(String str) {
        return NumberUtils.toInt((String)str);
    }

    public static int safeObjToInt(Object obj) {
        return NumberUtils.toInt((String)StringHelp.safeToString(obj));
    }

    public static long safeStringToLong(String str) {
        return NumberUtils.toLong((String)str);
    }

    public static boolean safeStringToBoolean(String str) {
        return BooleanUtils.toBoolean((String)str);
    }

    public static float safeStringToFloat(String str) {
        return NumberUtils.toFloat((String)str);
    }

    public static double safeStringToDouble(String str) {
        return NumberUtils.toDouble((String)str);
    }

    public static short safeStringToShort(String str) {
        return NumberUtils.toShort((String)str);
    }

    public static Date safeStringToDateTime(String str) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ParsePosition pos = new ParsePosition(0);
        Date strtodate = formatter.parse(str, pos);
        return strtodate;
    }

    public static Date safeStringToTimestamp(String value, String format) {
        if (ValidatorUtil.isTimestamp(value, format)) {
            ParsePosition pos = new ParsePosition(0);
            return new SimpleDateFormat(format).parse(value, pos);
        }
        return new Date(14400000L);
    }

    public static BigDecimal safeStringToBigDecimal(String str) {
        BigDecimal decimalValue = BigDecimal.ZERO;
        try {
            decimalValue = new BigDecimal(str);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return decimalValue;
    }

    public static boolean ignoreCaseEquals(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equalsIgnoreCase(str2);
    }

    public static boolean equals(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equals(str2);
    }

    public static String[] safeSplit_blank(String str) {
        if (str == null) {
            return new String[0];
        }
        return str.split("\\s+");
    }

    public static List<Long> safeSplit_toLongList(String str, String cr) {
        if (StringHelp.safeIsEmpty(str)) {
            return new ArrayList<Long>();
        }
        return Arrays.asList(str.split(cr)).stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
    }

    public static String safeLastSplit(String str, String c) {
        if (StringHelp.safeIsEmpty(str)) {
            return "";
        }
        String[] res = str.split(c);
        if (0 == res.length) {
            return "";
        }
        return res[res.length - 1];
    }

    public static boolean safeContains(String str, String chars) {
        if (str == null) {
            return false;
        }
        return str.contains(chars);
    }

    public static boolean isNumeric(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String join(Collection<?> collection, String separator) {
        Iterator<?> iterator = collection.iterator();
        if (iterator == null) {
            return "";
        }
        if (!iterator.hasNext()) {
            return "";
        }
        Object first = iterator.next();
        StringBuilder buf = new StringBuilder(256);
        buf.append(StringHelp.safeToString(first));
        while (iterator.hasNext()) {
            buf.append(separator);
            Object obj = iterator.next();
            if (obj == null) continue;
            buf.append(StringHelp.safeToString(obj));
        }
        return buf.toString();
    }

    public static String trimEnd(String source) {
        if (StringUtils.isBlank((CharSequence)source)) {
            return "";
        }
        if (source.length() < 2) {
            return source;
        }
        return source.substring(0, source.length() - 1);
    }

    public static String trimEnd(StringBuilder source) {
        if (source == null || source.length() == 0) {
            return "";
        }
        if (source.length() < 2) {
            return source.toString();
        }
        return source.substring(0, source.length() - 1);
    }

    public static Integer getLength(String value) {
        Integer ret = 0;
        if (StringHelp.safeIsEmpty(value)) {
            return ret;
        }
        ret = value.length();
        String reg = "[\u4e00-\u9fa5]";
        Pattern p = Pattern.compile(reg);
        Matcher m = p.matcher(value);
        while (m.find()) {
            Integer n = ret;
            Integer n2 = ret = Integer.valueOf(ret + 1);
        }
        return ret;
    }

    public static String getRandomCode(int length) {
        StringBuilder str = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            str.append(random.nextInt(10));
        }
        return str.toString();
    }

    public static String substring(String str, int x, int y) {
        System.out.println(str.length());
        if (x > str.length()) {
            return "";
        }
        if (y > str.length()) {
            return str.substring(x, str.length());
        }
        return str.substring(x, y);
    }
}

