/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.system.paas;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.annotation.LogApi;
import com.xforceplus.elephant.basecommon.enums.log.ReceiverEnum;
import com.xforceplus.elephant.basecommon.enums.log.SenderEnum;
import com.xforceplus.elephant.basecommon.enums.log.SystemTypeEnum;
import com.xforceplus.elephant.basecommon.exception.ElephantException;
import com.xforceplus.elephant.basecommon.help.HttpUtils;
import com.xforceplus.elephant.basecommon.help.StringHelp;
import com.xforceplus.elephant.basecommon.log.MyThreadLocal;
import com.xforceplus.elephant.basecommon.system.paas.PaasTokenUtils;
import com.xforceplus.elephant.basecommon.system.paas.SystemPaasSettings;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserUtils {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SystemPaasSettings systemPaasSettings;
    @Autowired
    private PaasTokenUtils paasTokenUtils;

    @LogApi(methodCode="getUserInfoRequest", methodDescription="\u83b7\u53d6\u7528\u6237\u4fe1\u606f", systemType=SystemTypeEnum.IMAGE, isRetry=0, sender=SenderEnum.IMAGE, receiver=ReceiverEnum.PHOENIX)
    public JSONObject getUserInfoRequest(Long tenantId, String userId, String userCode) {
        try {
            MyThreadLocal.setObject(tenantId, userCode, "", "");
            String url = this.systemPaasSettings.getUserInfoUrl().replace("{tenantId}", String.valueOf(tenantId));
            String token = this.paasTokenUtils.getLoginToken();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            headers.put("x-app-token", token);
            HashMap<String, String> params = new HashMap<String, String>();
            if (ValidatorUtil.isNotEmpty(userId)) {
                params.put("userId", userId);
            }
            if (ValidatorUtil.isNotEmpty(userCode)) {
                params.put("userCode", userCode);
            }
            this.logger.debug("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}, \u53c2\u6570\uff1a{}", new Object[]{tenantId, url, params});
            String responseStr = HttpUtils.doGet(url, headers, params);
            this.logger.debug("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)tenantId, (Object)responseStr);
            JSONObject jsonObject = JSONObject.parseObject((String)responseStr);
            if (ValidatorUtil.isEmpty((Map)jsonObject)) {
                this.logger.warn("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5f02\u5e38");
                throw new ElephantException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5f02\u5e38");
            }
            JSONObject jsonResult = null;
            JSONArray array = null;
            jsonResult = jsonObject.getJSONObject("result");
            if (jsonResult != null && (array = jsonResult.getJSONArray("content")) != null && array.size() > 0) {
                return array.getJSONObject(0);
            }
            this.logger.warn("\u672a\u83b7\u53d6\u5230\u7528\u6237\u4fe1\u606f");
            return null;
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new ElephantException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5f02\u5e38", e);
        }
    }

    @LogApi(methodCode="getUserIdRequest", methodDescription="\u83b7\u53d6\u7528\u6237id", systemType=SystemTypeEnum.IMAGE, isRetry=0, sender=SenderEnum.IMAGE, receiver=ReceiverEnum.PHOENIX)
    public List<Long> getUserIds(Long tenantId, List<Long> roleIds) {
        try {
            MyThreadLocal.setObject(tenantId, StringHelp.safeToString(roleIds), "", "");
            String url = this.systemPaasSettings.getUserInfoUrl().replace("{tenantId}", String.valueOf(tenantId));
            String token = this.paasTokenUtils.getLoginToken();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            headers.put("x-app-token", token);
            ArrayList<Long> userIds = new ArrayList<Long>();
            roleIds.stream().forEach(roleId -> {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("roleId", StringHelp.safeToString(roleId));
                this.logger.debug("\u83b7\u53d6\u89d2\u8272\u4e0b\u7528\u6237\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}, \u53c2\u6570\uff1a{}", new Object[]{tenantId, url, params});
                String responseStr = HttpUtils.doGet(url, headers, params);
                this.logger.debug("\u83b7\u53d6\u89d2\u8272\u4e0b\u7528\u6237\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)tenantId, (Object)responseStr);
                JSONObject jsonObject = JSONObject.parseObject((String)responseStr);
                if (ValidatorUtil.isEmpty((Map)jsonObject)) {
                    this.logger.warn("\u83b7\u53d6\u89d2\u8272\u4e0b\u7528\u6237\u5f02\u5e38");
                    throw new ElephantException("\u83b7\u53d6\u89d2\u8272\u4e0b\u7528\u6237\u5f02\u5e38");
                }
                JSONObject jsonResult = null;
                JSONArray array = null;
                jsonResult = jsonObject.getJSONObject("result");
                if (jsonResult != null && (array = jsonResult.getJSONArray("content")) != null && array.size() > 0) {
                    for (int i = 0; i < array.size(); ++i) {
                        JSONObject user = array.getJSONObject(i);
                        userIds.add(user.getLongValue("id"));
                    }
                }
            });
            return userIds;
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u89d2\u8272\u4e0b\u7528\u6237\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new ElephantException("\u83b7\u53d6\u89d2\u8272\u4e0b\u7528\u6237\u5f02\u5e38", e);
        }
    }

    @LogApi(methodCode="getUserIds", methodDescription="\u83b7\u53d6\u89d2\u8272\u4e0b\u7528\u6237", systemType=SystemTypeEnum.IMAGE, isRetry=0, sender=SenderEnum.IMAGE, receiver=ReceiverEnum.PHOENIX)
    public JSONArray getUsers(Long tenantId, List<Long> roleIds) {
        try {
            MyThreadLocal.setObject(tenantId, StringHelp.safeToString(roleIds), "", "");
            String url = this.systemPaasSettings.getUserInfoUrl().replace("{tenantId}", String.valueOf(tenantId));
            String token = this.paasTokenUtils.getLoginToken();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            headers.put("x-app-token", token);
            JSONArray users = new JSONArray();
            roleIds.stream().forEach(roleId -> {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("roleId", StringHelp.safeToString(roleId));
                this.logger.debug("\u83b7\u53d6\u89d2\u8272\u4e0b\u7528\u6237\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}, \u53c2\u6570\uff1a{}", new Object[]{tenantId, url, params});
                String responseStr = HttpUtils.doGet(url, headers, params);
                this.logger.debug("\u83b7\u53d6\u89d2\u8272\u4e0b\u7528\u6237\uff0c\u79df\u6237ID\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)tenantId, (Object)responseStr);
                JSONObject jsonObject = JSONObject.parseObject((String)responseStr);
                if (ValidatorUtil.isEmpty((Map)jsonObject)) {
                    this.logger.warn("\u83b7\u53d6\u89d2\u8272\u4e0b\u7528\u6237\u5f02\u5e38");
                    throw new ElephantException("\u83b7\u53d6\u89d2\u8272\u4e0b\u7528\u6237\u5f02\u5e38");
                }
                JSONObject jsonResult = null;
                JSONArray array = null;
                jsonResult = jsonObject.getJSONObject("result");
                if (jsonResult != null && (array = jsonResult.getJSONArray("content")) != null && array.size() > 0) {
                    users.addAll((Collection)array);
                }
            });
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u89d2\u8272\u4e0b\u7528\u6237\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new ElephantException("\u83b7\u53d6\u89d2\u8272\u4e0b\u7528\u6237\u5f02\u5e38", e);
        }
        return new JSONArray();
    }
}

