/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.elephant.basecommon.controller;

import com.alibaba.fastjson.JSON;
import com.xforceplus.elephant.basecommon.log.LogApiEntity;
import com.xforceplus.elephant.basecommon.log.StartupListener;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CommonLogApiController {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    @RequestMapping(value={"/common/retryLogApi"}, method={RequestMethod.POST})
    public CommonResponse logApiRetry(@RequestBody LogApiEntity request) {
        try {
            this.retryInterfaces(request);
        }
        catch (Exception e) {
            this.logger.error("\u91cd\u8bd5\u5931\u8d25", (Throwable)e);
            return CommonResponse.failed("\u91cd\u8bd5\u5931\u8d25!");
        }
        return CommonResponse.ok("\u91cd\u8bd5\u6210\u529f!");
    }

    private boolean retryInterfaces(LogApiEntity logApiEntity) {
        Map<String, StartupListener.Target> map = StartupListener.getRegMethods();
        if (map.containsKey(logApiEntity.getMethodCode())) {
            StartupListener.Target target = map.get(logApiEntity.getMethodCode());
            Object[] objects = JSON.parseArray((String)logApiEntity.getParams(), (Type[])target.getMethod().getGenericParameterTypes()).toArray();
            try {
                target.getMethod().invoke(target.getBean(), objects);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return true;
    }
}

